﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using Vindicia;
using Curse.Extensions;
using Curse.Billing.Models;

namespace Curse.Billing.Extensions
{
    public static class AccountPaymentTypeExtensions
    {

        public static PaymentMethodType ToVindicia(this AccountPaymentType value)
        {
            switch (value)
            {
                case AccountPaymentType.AMEX:
                case AccountPaymentType.Maestro:
                case AccountPaymentType.CreditCard:
                    return PaymentMethodType.CreditCard;
                case AccountPaymentType.PayPal:
                    return PaymentMethodType.PayPal;
                case AccountPaymentType.Token: //TODO: can all this voice stuff go bye bye?
                    return PaymentMethodType.Token;
                case AccountPaymentType.DirectDebit:
                    return PaymentMethodType.DirectDebit;
                    
                default:
                    throw new NotImplementedException("Unknown payment type: {0}".FormatWith(value));
            }
        }

    }
}
