﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Billing.Extensions
{
    public static class DateTimeExtensions
    {
        private static string _timeZoneID = "Pacific Standard Time";
        private static TimeZoneInfo _timeZoneInfo = null;
        static DateTimeExtensions()
        {
            _timeZoneInfo = TimeZoneInfo.FindSystemTimeZoneById(_timeZoneID);         
        }

        public static DateTime PrepareForVindicia(this DateTime value)
        {
            // Convert to PST
            return TimeZoneInfo.ConvertTimeFromUtc(value, _timeZoneInfo);
        }

        public static DateTime ConvertFromVindicia(this DateTime value)
        {
            return new DateTime(value.Ticks, DateTimeKind.Local).ToUniversalTime();            
        }
    }
}
