﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Reflection;
using System.Collections;

namespace Curse.Billing.Extensions
{
    public static class ObjectExtension
    {

        public static string DumpAllProperties(this object value)
        {
            PropertyInfo[] fields = value.GetType().GetProperties(BindingFlags.Instance | BindingFlags.Public);
            string objectDump = string.Empty;

            if (fields.Length == 0)
            {
                return value.ToString();
            }

            foreach (PropertyInfo info in fields)
            {               

                object fieldValue = null;
                try
                {
                    fieldValue = info.GetValue(value, null);
                }
                catch
                {
                    continue;
                }

                if (fieldValue == null)
                {
                    continue;
                }

                if (fieldValue.GetType().IsClass && !fieldValue.GetType().IsPrimitive && !(fieldValue is string))
                {
                    objectDump += "<fieldset><legend>" + info.Name + "</legend>";

                    if (fieldValue is IEnumerable)
                    {
                        int index = 0;
                        foreach (object x in fieldValue as IEnumerable)
                        {
                            if (x.GetType().IsPrimitive)
                            {
                                objectDump += x.ToString() + Environment.NewLine;
                            }
                            else
                            {
                                objectDump += "<fieldset><legend>" + (++index).ToString() + "</legend>";
                                objectDump += x.DumpAllProperties();
                                objectDump += "</fieldset>";
                            }

                        }
                    }
                    else
                    {
                        objectDump += "<b>" + info.Name + "</b><br>" + fieldValue.DumpAllProperties();
                    }

                    objectDump += "</fieldset>";
                }
                else
                {
                    objectDump += "<b>" + info.Name + ":</b> " + fieldValue.ToString() + "<br>";
                }
            }

            return objectDump;
        }
    }
}
