﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Vindicia;
using Curse.Extensions;
using Curse.Billing.Models;

namespace Curse.Billing.Extensions
{
    public static class PaymentMethodTypeExtensions
    {

        public static AccountPaymentType ToCurse(this PaymentMethodType value)
        {
            switch (value)
            {
                case PaymentMethodType.CreditCard:
                    return AccountPaymentType.CreditCard;
                case PaymentMethodType.PayPal:
                    return AccountPaymentType.PayPal;
                case PaymentMethodType.Token: //TODO: can all this voice stuff go bye bye?
                    return AccountPaymentType.Token;
                case PaymentMethodType.DirectDebit:
                    return AccountPaymentType.DirectDebit;
                default:
                    throw new NotImplementedException("Unknown payment type: {0}".FormatWith(value));
            }
        }
    }
}
