﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using Vindicia;
using Curse.Extensions;
using Curse.Billing.Models;


namespace Curse.Billing.Extensions
{
    public static class SubscriptionStatusExtensions
    {
        public static AutoBillStatus ToVindicia(this SubscriptionStatus value)
        {
            switch (value)
            {
                case SubscriptionStatus.Active:
                    return AutoBillStatus.Active;
                case SubscriptionStatus.Cancelled:
                    return AutoBillStatus.Cancelled;
                case SubscriptionStatus.PendingCustomerAction:
                    return AutoBillStatus.PendingCustomerAction;
                case SubscriptionStatus.Suspended:
                    return AutoBillStatus.Suspended;
                case SubscriptionStatus.Upgraded:
                    return AutoBillStatus.Upgraded;
                default:
                    throw new NotImplementedException("Unknown subscription status: {0}".FormatWith(value));
            }
        }
    }
}
