﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Vindicia;
using Curse.Billing.Models;

namespace Curse.Billing.Extensions
{
    public static class TransactionStatusTypeExtensions
    {
        public static AccountTransactionStatus ToCurse(this TransactionStatusType value)
        {
            switch (value)
            {
                case TransactionStatusType.AuthorizationPending:
                    return AccountTransactionStatus.AuthorizationPending;

                case TransactionStatusType.AuthorizedPending:
                    return AccountTransactionStatus.AuthorizedPending;

                case TransactionStatusType.Authorized:
                    return AccountTransactionStatus.Authorized;

                case TransactionStatusType.AuthorizedForValidation:
                    return AccountTransactionStatus.AuthorizedForValidation;

                case TransactionStatusType.Cancelled:
                    return AccountTransactionStatus.Cancelled;

                case TransactionStatusType.Captured:
                    return AccountTransactionStatus.Captured;
                

                case TransactionStatusType.Pending:
                    return AccountTransactionStatus.Pending;

                
                case TransactionStatusType.New:
                    return AccountTransactionStatus.New;

                case TransactionStatusType.Settled:
                    return AccountTransactionStatus.Settled;

                case TransactionStatusType.Refunded:
                    return AccountTransactionStatus.Refunded;                                       

                default:
                    return AccountTransactionStatus.Failed;
            }
        }

        
    }
}
