﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using System.ServiceModel.Web;
using System.Net.Security;
using Curse.Billing.Models;
using System.Net;

namespace Curse.Billing
{
    // NOTE: If you change the interface name "IService1" here, you must also update the reference to "IService1" in Web.config.
    [ServiceContract(Namespace = "http://billingservice.curse.com/", ProtectionLevel = ProtectionLevel.None)]
    public interface IBillingService
    {

        [OperationContract]
        [WebGet(UriTemplate = "/CreateCoupon?referenceBillingPlanID={referenceBillingPlanID}")]
        ServiceResponse<Coupon> CreateCoupon(string referenceBillingPlanID);

        [OperationContract]
        [WebInvoke(UriTemplate = "/ClaimCoupon", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse ClaimCoupon(int userID, int cobaltInstanceID, int entityTypeID, int entityID, string code, string accountID);

        [OperationContract]
        [WebGet(UriTemplate = "/ValidateCoupon?code={code}&accountID={accountID}")]
        ServiceResponse ValidateCoupon(string code, string accountID);

        [OperationContract]
        [WebGet(UriTemplate = "/GetProductOffering?id={id}")]
        ServiceResponse<ProductOffering> GetProductOffering(string id);

        [OperationContract]
        [WebGet(UriTemplate = "/GetProductOfferingByGroupID?groupID={groupID}")]
        ServiceResponse<ProductOffering[]> GetProductOfferingByGroupID(string groupID);

        [OperationContract]
        [WebGet(UriTemplate = "/GetAllProductOfferings")]
        ServiceResponse<ProductOffering[]> GetAllProductOfferings();

        [OperationContract]
        [WebGet(UriTemplate = "/GetProductBillingPlan?id={id}")]
        ServiceResponse<ProductBillingPlan> GetProductBillingPlan(string id);

        [OperationContract]
        [WebGet(UriTemplate = "/GetAccountEntitlements?accountID={accountID}")]
        ServiceResponse<List<AccountEntitlement>> GetAccountEntitlements(string accountID);

        [OperationContract]
        [WebGet(UriTemplate = "/GetExpiredAccountEntitlements?entitlementID={entitlementID}&dateFrom={dateFrom}&dateTo={dateTo}")]
        ServiceResponse<List<AccountEntitlement>> GetExpiredAccountEntitlements(string entitlementID, DateTime dateFrom, DateTime dateTo);

        [OperationContract]
        [WebInvoke(UriTemplate = "/CreateOrUpdateAccount", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse CreateOrUpdateAccount(AccountInformation accountInformation);

        [OperationContract]
        [WebGet(UriTemplate = "/GetAccountInformation?accountID={accountID}")]
        ServiceResponse<AccountInformation> GetAccountInformation(string accountID);

        [OperationContract]
        [WebGet(UriTemplate = "/ResyncAccountInformation?accountID={accountID}")]
        ServiceResponse ResyncAccountInformation(string accountID);

        [OperationContract]
        [WebGet(UriTemplate = "/ResyncAccountEntitlements?accountID={accountID}")]
        ServiceResponse ResyncAccountEntitlements(string accountID);

        [OperationContract]
        [WebInvoke(UriTemplate = "/PurchaseProducts", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse<Checkout> PurchaseProducts(int userID, int cobaltInstanceID, int entityTypeID, int entityID, string accountID, string paymentMethodID, AccountPaymentMethod paymentMethod, ShoppingCart shoppingCart);

        [OperationContract]
        [WebInvoke(UriTemplate = "/CreateTokenSubscriptions", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse<List<Subscription>> CreateTokenSubscriptions(int userID, int cobaltInstanceID, int entityTypeID, int entityID, string accountID, ShoppingCart cart);
        
        [OperationContract]
        [WebGet(UriTemplate = "/FinalizePayPalTransaction?vid={vid}&payPalToken={payPalToken}")]
        ServiceResponse<Checkout> FinalizePayPalTransaction(string vid, string payPalToken);
       
        [OperationContract]
        [WebInvoke(UriTemplate = "/v2ChangeSubscriptionPlan", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse<Checkout> v2ChangeSubscriptionPlan(int userID, int cobaltInstanceID, int entityTypeID, int entityID, string accountID, string paymentMethodID, AccountPaymentMethod paymentMethod, CurrencyType currency, string subscriptionID, string newBillingPlanID, bool terminateExistingSub, int newSubCreditDays);

        [OperationContract]
        [WebInvoke(UriTemplate = "/ChangeSubscriptionPlan", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse<Checkout> ChangeSubscriptionPlan(int userID, int cobaltInstanceID, int entityTypeID, int entityID, string accountID, string paymentMethodID, AccountPaymentMethod paymentMethod, string subscriptionID, string newBillingPlanID, bool terminateExistingSub, int newSubCreditDays);

        [OperationContract]
        [WebGet(UriTemplate = "/CancelSubscription?userID={userID}&accountID={accountID}&subscriptionID={subscriptionID}&note={note}")]
        ServiceResponse CancelSubscription(int userID, string accountID, string subscriptionID, string note);

        [OperationContract]
        [WebGet(UriTemplate = "/TerminateSubscription?userID={userID}&accountID={accountID}&subscriptionID={subscriptionID}&note={note}")]
        ServiceResponse TerminateSubscription(int userID, string accountID, string subscriptionID, string note);


        [OperationContract]
        [WebInvoke(UriTemplate = "/CreateOrUpdatePaymentMethod", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse<AccountPaymentMethod> CreateOrUpdatePaymentMethod(string accountID, AccountPaymentMethod paymentMethod);

        [OperationContract]
        [WebGet(UriTemplate = "/GetPurchasedCoupons?accountID={accountID}")]        
        ServiceResponse<List<Coupon>> GetPurchasedCoupons(string accountID);

        [OperationContract]
        [WebGet(UriTemplate = "/GetClaimedCoupons?accountID={accountID}")]
        ServiceResponse<List<Coupon>> GetClaimedCoupons(string accountID);

        [OperationContract]
        [WebGet(UriTemplate = "/GetCoupon?code={code}")]
        ServiceResponse<Coupon> GetCoupon(string code);

        [OperationContract]
        [WebGet(UriTemplate = "/GetCheckout?transactionID={transactionID}&accountID={accountID}")]
        ServiceResponse<Checkout> GetCheckout(int transactionID, string accountID);

        [OperationContract]
        [WebGet(UriTemplate = "/GetSubscriptionByID?subscriptionID={subscriptionID}")]
        ServiceResponse<Subscription> GetSubscriptionByID(string subscriptionID);

        [OperationContract]
        [WebGet(UriTemplate = "/GetSubscriptionByUserID?userID={userID}")]
        ServiceResponse<List<Subscription>> GetSubscriptionByUserID(int userID);

        [OperationContract]
        [WebGet(UriTemplate = "/GetTransactionsForUser?userID={userID}&userAccountID={userAccountID}")]
        ServiceResponse<List<AccountTransaction>> GetTransactionsForUser(int userID, string userAccountID);

        [OperationContract]
        [WebGet(UriTemplate = "/CreditSubscription?userID={userID}&userAccountID={userAccountID}&subscriptionID={subscriptionID}&days={days}&note={note}")]
        ServiceResponse CreditSubscription(int userID, string userAccountID, string subscriptionID, int days, string note);

        [OperationContract]
        [WebGet(UriTemplate = "/IssueRefund?userID={userID}&transactionID={transactionID}&amount={amount}&note={note}")]
        ServiceResponse IssueRefund(int userID, string transactionID, decimal amount, string note);


        #region Voice
        //TODO: can all this voice stuff go bye bye?
        [OperationContract]
        [WebInvoke(UriTemplate = "/CreditTokens", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse CreditTokens(string adminName, string accountID, IEnumerable<AccountTokenAmount> amounts);

        [OperationContract]
        [WebInvoke(UriTemplate = "/DeductTokens", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse DeductTokens(string adminName, string accountID, IEnumerable<AccountTokenAmount> amounts);

        [OperationContract]
        [WebGet(UriTemplate = "/GetAccountVoiceClient?accountID={accountID}")]
        ServiceResponse<AccountVoiceClient> GetAccountVoiceClient(string accountID);

        [OperationContract]
        [WebInvoke(UriTemplate = "/AddAccountVoiceService", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse<AccountVoiceClient> AddAccountVoiceService(string accountID, Int64 clientID, Int64 serviceID, IPAddress ipAddress, int port);

        [OperationContract]
        [WebGet(UriTemplate = "/DeleteAccountVoiceService?accountID={accountID}&serviceID={serviceID}")]
        ServiceResponse DeleteAccountVoiceService(string accountID, Int64 serviceID);

        [OperationContract]
        [WebInvoke(UriTemplate = "/UpdateAccountVoiceService", Method = "POST", BodyStyle = WebMessageBodyStyle.Wrapped, RequestFormat = WebMessageFormat.Json, ResponseFormat = WebMessageFormat.Xml)]
        ServiceResponse UpdateAccountVoiceService(string accountID, Int64 serviceID, IPAddress ipAddress, int port, AccountVoiceServiceStatus status, DateTime dateLastMoved);

        [OperationContract]
        [WebGet(UriTemplate = "/GetAccountVoiceClientsByPage?pageNumber={pageNumber}&pageSize={pageSize}")]
        ServiceResponse<PagedRecords<AccountVoiceClient>> GetAccountVoiceClientsByPage(int pageNumber, int pageSize); 
        #endregion

        [OperationContract]
        [WebGet(UriTemplate = "/GetCountryBillingOptions")]
        ServiceResponse<CountryBillingOption[]> GetCountryBillingOptions();

        [OperationContract]
        [WebGet(UriTemplate = "/HealthCheck")]
        ServiceResponse<string> HealthCheck();

        [WebGet(UriTemplate = "/SyncAccountSubscriptions?accountID={accountID}")]
        void SyncAccountSubscriptions(string accountID);

        [WebGet(UriTemplate = "/SyncSuspectAccountSubscriptions")]
        void SyncSuspectAccountSubscriptions();
    }


}
