﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using Vindicia;

namespace Curse.Billing.Models
{
    [DataContract]
    public class AccountAddress
    {
        [DataMember]
        public string Name { get; set; }

        [DataMember]
        public string Address1 { get; set; }

        [DataMember]
        public string Address2 { get; set; }

        [DataMember]
        public string Address3 { get; set; }

        [DataMember]
        public string City { get; set; }

        [DataMember]
        public string Country { get; set; }

        [DataMember]
        public string Phone { get; set; }

        [DataMember]
        public string PostalCode { get; set; }

        [DataMember]
        public string District { get; set; }

        public AccountAddress() { }

        public AccountAddress(Address vindiciaAddress)
        {
            if (vindiciaAddress != null)
            {
                this.Address1 = vindiciaAddress.addr1;
                this.Address2 = vindiciaAddress.addr2;
                this.Address3 = vindiciaAddress.addr3;
                this.District = vindiciaAddress.district;
                this.City = vindiciaAddress.city;
                this.Country = vindiciaAddress.country;
                this.Phone = vindiciaAddress.phone;
                this.PostalCode = vindiciaAddress.postalCode;
                this.Name = vindiciaAddress.name;
            }
        }

        public Address ToVindicia()
        {
            return new Address()
            {
                addr1 = this.Address1,
                addr2 = this.Address2,
                addr3 = this.Address3,
                district = this.District,
                city = this.City,
                country = this.Country,
                phone = this.Phone,
                postalCode = this.PostalCode,
                name = this.Name
            };
        }
        
    }
}
