﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Runtime.Serialization;
using System.Data;
using Curse.Billing.Configuration;
using Curse.Billing.Extensions;
using Curse.Extensions;
using System.Web;
using Vindicia;


namespace Curse.Billing.Models
{
    [DataContract]
    public class AccountEntitlement
    {
        private const string CacheKey = "AccountEntitlementByAccount-{0}";
        
        #region Properties
        
        public int ID
        {
            get;
            set;
        }
        
        [DataMember]
        public string AccountID
        {
            get;
            set;
        }

        [DataMember]
        public string EntitlementID
        {
            get;
            set;
        }

        [DataMember]
        public DateTime DateUpdated
        {
            get;
            set;
        }

        [DataMember]
        public DateTime DateExpires
        {
            get;
            set;
        }

        [DataMember]
        public bool Active
        {
            get; set;
        }

        #endregion

        public AccountEntitlement() { }

        public AccountEntitlement(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            AccountID = reader.GetString(1);
            EntitlementID = reader.GetString(2);
            DateUpdated = reader.GetDateTime(3);
            DateExpires = reader.GetDateTime(4);
            Active = reader.GetBoolean(5);
        }

        public static List<AccountEntitlement> GetByAccountID(string accountID)
        {
            return HttpRuntime.Cache.Get(CacheKey.FormatWith(accountID), () =>
            {
                return GetFromDatabaseByAccountID(accountID);
            }); 
           
        }

        public static void ExpireByAccountID(string accountID)
        {
            HttpRuntime.Cache.Expire(CacheKey.FormatWith(accountID));
        }

        public static List<AccountEntitlement> GetExpiredByTypeAndDate(string entitlementID, DateTime dateFrom, DateTime dateTo)
        {
            List<AccountEntitlement> entitlements = new List<AccountEntitlement>();
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select * from AccountEntitlement where EntitlementID = @EntitlementID and DateExpires between @DateFrom and @DateTo and IsActive = 0";

                SqlParameter entitlementIDParameter = cmd.Parameters.Add("@EntitlementID", System.Data.SqlDbType.VarChar);
                entitlementIDParameter.Value = entitlementID;

                SqlParameter dateFromParameter = cmd.Parameters.Add("@DateFrom", System.Data.SqlDbType.DateTime);
                dateFromParameter.Value = dateFrom;

                SqlParameter dateToParameter = cmd.Parameters.Add("@DateTo", System.Data.SqlDbType.DateTime);
                dateToParameter.Value = dateTo;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        entitlements.Add(new AccountEntitlement(reader));
                    }
                }
            }

            return entitlements;
        }

        public static List<AccountEntitlement> GetExpiredByType(string entitlementID)
        {
            List<AccountEntitlement> entitlements = new List<AccountEntitlement>();
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select * from AccountEntitlement where EntitlementID = @EntitlementID and IsActive = 0";

                SqlParameter entitlementIDParameter = cmd.Parameters.Add("@EntitlementID", System.Data.SqlDbType.VarChar);
                entitlementIDParameter.Value = entitlementID;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        entitlements.Add(new AccountEntitlement(reader));
                    }
                }
            }

            return entitlements;
        }

        private static List<AccountEntitlement> GetFromDatabaseByAccountID(string accountID)
        {
            List<AccountEntitlement> entitlements = new List<AccountEntitlement>();
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select * from AccountEntitlement where AccountID = @AccountID";
                SqlParameter accountIDParameter = cmd.Parameters.Add("@AccountID", System.Data.SqlDbType.VarChar);
                accountIDParameter.Value = accountID;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        entitlements.Add(new AccountEntitlement(reader));
                    }
                }
            }

            return entitlements;
        }

        public bool Save()
        {
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                return Save(conn);
            }
        }

        public bool Save(SqlConnection conn)
        {
            SqlCommand cmd = conn.CreateCommand();
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.CommandText = "spUpdateEntitlementV2";
            cmd.Parameters.Add("@AccountID", SqlDbType.VarChar);
            cmd.Parameters.Add("@EntitlementID", SqlDbType.VarChar);
            cmd.Parameters.Add("@DateExpires", SqlDbType.DateTime);
            cmd.Parameters.Add("@Active", SqlDbType.Bit);
            cmd.Parameters["@AccountID"].Value = this.AccountID;
            cmd.Parameters["@EntitlementID"].Value = this.EntitlementID;
            cmd.Parameters["@DateExpires"].Value = this.DateExpires;
            cmd.Parameters["@Active"].Value = this.Active;
            cmd.ExecuteNonQuery();
            this.Expire();
            return true;
        }

        public void Expire()
        {
            HttpRuntime.Cache.Expire(CacheKey.FormatWith(this.AccountID));
        }

        public static AccountEntitlement FromVindicia(Entitlement entitlement)
        {
            return new AccountEntitlement()
            {
                AccountID = entitlement.account.merchantAccountId,                
                DateExpires = entitlement.endTimestamp.ConvertFromVindicia(),
                DateUpdated = DateTime.UtcNow,
                EntitlementID = entitlement.merchantEntitlementId,   
                Active = entitlement.active,
            };
        }
    }
}
