﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using Vindicia;

namespace Curse.Billing.Models
{
    [DataContract]
    public class AccountTokenAmount
    {
        [DataMember]
        public int Amount { get; private set; }

        [DataMember]
        public AccountTokenType Type { get; private set; }

        public AccountTokenAmount(AccountTokenType type, int amt)
        {
            Type = type;
            Amount = amt;
        }

        public static AccountTokenAmount FromVindicia(TokenAmount tokenAmount)
        {
            return new AccountTokenAmount(AccountTokenType.FromVindicia(tokenAmount.token), tokenAmount.amount);
        }
        
    }
}
