﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using Vindicia;
using Curse.Billing.Data;

namespace Curse.Billing.Models
{
    [DataContract]
    public class AccountTokenType
    {
        [DataMember]
        public string ID { get; private set; }

        [DataMember]
        public string Description { get; private set; }

        private AccountTokenType(string id, string description)
        {
            ID = id;
            Description = description;
        }
        
        public static AccountTokenType FetchByID(string id)
        {
            Token token = Retrieval.GetTokenByID(id);
            return FromVindicia(token);
        }

        public static AccountTokenType FromVindicia(Token token)
        {
            return new AccountTokenType(token.merchantTokenId, token.description);
        }

        internal Token ToVindicia()
        {
            return Retrieval.GetTokenByID(ID);
        }
    }
}
