﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using System.Data.SqlClient;
using Curse.Extensions;
using Curse.Billing.Configuration;
using Curse.Billing.Extensions;
using System.Data;
using Vindicia;

namespace Curse.Billing.Models
{
    [DataContract]
    public class AccountTransactionItem
    {

        #region Constructors

        public AccountTransactionItem()
        {
        }

        protected AccountTransactionItem(SqlDataReader reader)
        {
            this.ID = reader.GetInt32(0);
            this.TransactionID = reader.GetInt32(1);
            this.ProductID = reader.GetString(2);
            if (reader[3] != System.DBNull.Value)
            {
                this.Description = reader.GetString(3);
            }
            this.Price = reader.GetDecimal(4);
            this.Quantity = reader.GetInt32(5);
            this.SubTotal = reader.GetDecimal(6);
        }

        #endregion

        #region Properties

        [DataMember]
        public int ID
        {
            get;
            set;
        }

        [DataMember]
        public int TransactionID
        {
            get;
            set;
        }

        [DataMember]
        public string ProductID
        {
            get;
            set;
        }

        [DataMember]
        public string Description
        {
            get;
            set;
        }
      
        [DataMember]
        public decimal Price
        {
            get;
            set;
        }

        [DataMember]
        public decimal SubTotal
        {
            get;
            set;
        }

        [DataMember]
        public int Quantity
        {
            get;
            set;
        }

        #endregion

        public void Save()
        {
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandType = System.Data.CommandType.StoredProcedure;
                cmd.CommandText = "spUpdateAccountTransactionItem";

                SqlParameter idParameter = null;
                idParameter = cmd.Parameters.Add("@ID", SqlDbType.Int);
                idParameter.Direction = ParameterDirection.InputOutput;
                if (this.ID > 0)
                {
                    idParameter.Value = this.ID;
                }

                SqlParameter param = null;

                param = cmd.Parameters.Add("@TransactionID", SqlDbType.Int);                
                param.Value = this.TransactionID;

                param = cmd.Parameters.Add("@ProductID", SqlDbType.VarChar);
                param.Size = 64;
                param.Value = this.ProductID;

                param = cmd.Parameters.Add("@Description", SqlDbType.NVarChar);
                param.Size = 256;
                param.Value = this.Description;
               
                param = cmd.Parameters.Add("@Price", SqlDbType.Money);
                param.Value = this.Price;

                param = cmd.Parameters.Add("@SubTotal", SqlDbType.Money);
                param.Value = this.SubTotal;

                param = cmd.Parameters.Add("@Quantity", SqlDbType.Int);
                param.Value = this.Quantity;                

                cmd.ExecuteNonQuery();                                

                if (this.ID == 0)
                {
                    this.ID = (int)idParameter.Value;
                }


            }
        }

        public TransactionItem ToVindicia()
        {
            return new TransactionItem()
            {
                price = this.Price,
                quantity= this.Quantity,
                sku = this.ProductID,
                name = this.Description
            };
        }

        public static AccountTransactionItem FromVindicia(TransactionItem transactionItem)
        {
            return new AccountTransactionItem()
            {
                Price = transactionItem.price,
                Quantity = transactionItem.quantity,
                ProductID = transactionItem.sku,
                Description = transactionItem.name
            };
        }
        

        public static List<AccountTransactionItem> GetAllByTransactionID(int transactionID)
        {
            List<AccountTransactionItem> accountTransactionItems = new List<AccountTransactionItem>();
            List<int> ids = GetAllIDsFromDatabaseByTransactionID(transactionID);
            foreach (int id in ids)
            {
                AccountTransactionItem accountTransactionItem = GetByID(id, false);
                if (accountTransactionItem != null)
                {
                    accountTransactionItems.Add(accountTransactionItem);
                }
            }

            return accountTransactionItems;
        }

        public static AccountTransactionItem GetByID(int id, bool bypassCache)
        {
            return HttpRuntime.Cache.Get(bypassCache, "AccountTransactionItemByID-{0}".FormatWith(id), () =>
            {
                return GetFromDatabaseByID(id);
            });
        }

        private static AccountTransactionItem GetFromDatabaseByID(int id)
        {
            AccountTransactionItem accountTransactionItem = null;
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select * from AccountTransactionItem where ID = @ID";
                SqlParameter idParameter = cmd.Parameters.Add("@ID", SqlDbType.Int);
                idParameter.Value = id;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    if (reader.Read())
                    {
                        accountTransactionItem = new AccountTransactionItem(reader);
                    }
                }
            }

            return accountTransactionItem;
        }

        private static List<int> GetAllIDsFromDatabaseByTransactionID(int transactionID)
        {
            List<int> ids = new List<int>();
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select ID from AccountTransactionItem where TransactionID = @TransactionID";
                SqlParameter idParameter = cmd.Parameters.Add("@TransactionID", System.Data.SqlDbType.Int);
                idParameter.Value = transactionID;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        ids.Add(reader.GetInt32(0));
                    }
                }
            }

            return ids;
        }
    }
}
