﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using System.Data.SqlClient;
using Curse.Extensions;
using Curse.Billing.Configuration;
using Curse.Billing.Extensions;
using System.Data;
using System.Net;

//TODO: can all this voice stuff go bye bye?
namespace Curse.Billing.Models
{
    public enum AccountVoiceServiceStatus
    {
        Active,
        Inactive,
        Removed
    }

    [DataContract]
    public class AccountVoiceService
    {
        private const string CacheKey = "AccountVoiceService-{0}";

        public AccountVoiceService() { }
        
        protected AccountVoiceService(SqlDataReader reader)
        {
            this.ID = reader.GetInt32(0);
            this.AccountVoiceClientID = reader.GetInt32(1);
            this.ServiceID = reader.GetInt64(2);
            this.DateCreated = reader.GetDateTime(3);
            this.DateModified = reader.GetDateTime(4);

            byte[] ipAddressBytes = (byte[])reader.GetValue(5);            
            this.IPAddress = new IPAddress(ipAddressBytes);

            this.Port = reader.GetInt32(6);
            this.Status = (AccountVoiceServiceStatus)reader.GetByte(7);

            this.DateLastMoved = reader.GetDateTime(8);
        }
        
        public int ID
        {
            get;
            set;
        }        
        
        public int AccountVoiceClientID
        {
            get;
            set;
        }

        [DataMember]
        public Int64 ServiceID
        {
            get;
            set;
        }

        [DataMember]
        public DateTime DateCreated
        {
            get;
            set;
        }

        [DataMember]
        public DateTime DateModified
        {
            get;
            set;
        }

        [DataMember]
        public DateTime DateLastMoved
        {
            get;
            set;
        }

        [DataMember]
        public IPAddress IPAddress
        {
            get;
            set;
        }

        [DataMember]
        public int Port
        {
            get;
            set;
        }

        [DataMember]
        public AccountVoiceServiceStatus Status
        {
            get;
            set;
        }


        public void Delete()
        {
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandType = System.Data.CommandType.Text;
                cmd.CommandText = "delete from AccountVoiceService where ID = @ID";
                SqlParameter idParameter = cmd.Parameters.Add("@ID", SqlDbType.Int);
                idParameter.Value = this.ID;
                cmd.ExecuteNonQuery();                
            }
            this.Expire();
        }

        private void Expire()
        {
            HttpRuntime.Cache.Expire(CacheKey.FormatWith(this.ID));
        }

        public void Save()
        {
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandType = System.Data.CommandType.StoredProcedure;
                cmd.CommandText = "spUpdateAccountVoiceService";

                SqlParameter idParameter = null;
                idParameter = cmd.Parameters.Add("@ID", SqlDbType.Int);
                idParameter.Direction = ParameterDirection.InputOutput;
                if (this.ID > 0)
                {
                    idParameter.Value = this.ID;
                }

                SqlParameter param = null;

                param = cmd.Parameters.Add("@AccountVoiceClientID", SqlDbType.Int);
                param.Value = this.AccountVoiceClientID;

                param = cmd.Parameters.Add("@ServiceID", SqlDbType.BigInt);                
                param.Value = this.ServiceID;

                param = cmd.Parameters.Add("@IPAddress", SqlDbType.VarBinary);
                param.Size = 16;
                param.Value = this.IPAddress.GetAddressBytes();

                param = cmd.Parameters.Add("@Port", SqlDbType.Int);
                param.Value = this.Port;

                param = cmd.Parameters.Add("@Status", SqlDbType.TinyInt);
                param.Value = (byte)this.Status;

                param = cmd.Parameters.Add("@DateLastMoved", SqlDbType.DateTime);
                param.Value = this.DateLastMoved;

                cmd.ExecuteNonQuery();

                if (this.ID == 0)
                {
                    this.ID = (int)idParameter.Value;
                    this.DateCreated = DateTime.UtcNow;
                }
                
                 this.DateModified = DateTime.UtcNow;              
            }

            this.Expire();
        }

        public static AccountVoiceService GetByID(int id, bool bypassCache)
        {
            return HttpRuntime.Cache.Get(bypassCache, CacheKey.FormatWith(id), () =>
            {
                return GetFromDatabaseByID(id);
            });
        }

        private static AccountVoiceService GetFromDatabaseByID(int id)
        {
            AccountVoiceService accountVoiceService = null;
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select * from AccountVoiceService where ID = @ID";
                SqlParameter idParameter = cmd.Parameters.Add("@ID", SqlDbType.Int);
                idParameter.Value = id;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    if (reader.Read())
                    {
                        accountVoiceService = new AccountVoiceService(reader);
                    }
                }
            }

            return accountVoiceService;
        }

        public static List<AccountVoiceService> GetAllByClientID(int clientID)
        {
            List<AccountVoiceService> accountVoiceServices = new List<AccountVoiceService>();
            List<int> ids = GetAllIDsFromDatabaseByClientID(clientID);
            foreach (int id in ids)
            {
                AccountVoiceService accountVoiceService = GetByID(id, false);
                if (accountVoiceService != null)
                {
                    accountVoiceServices.Add(accountVoiceService);
                }
            }

            return accountVoiceServices;
        }

        private static List<int> GetAllIDsFromDatabaseByClientID(int clientID)
        {

            List<int> ids = new List<int>();
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select ID from AccountVoiceService where AccountVoiceClientID = @AccountVoiceClientID";
                SqlParameter clientIDParameter = cmd.Parameters.Add("@AccountVoiceClientID", System.Data.SqlDbType.Int);
                clientIDParameter.Value = clientID;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        ids.Add(reader.GetInt32(0));
                    }
                }
            }

            return ids;
        }


        public static PagedRecords<AccountVoiceService> GetAllByPage(int pageNumber, int pageSize)
        {                        
            if (pageNumber < 1)
            {
                throw new ArgumentException("pageNumber must be 1 or greater", "pageNumber");
            }

            
            int pageIndex = pageNumber - 1;
            int startingRow = (pageSize * pageIndex) + 1;
            int endingRow = (startingRow + pageSize) - 1;

            PagedRecords<AccountVoiceService> result = new PagedRecords<AccountVoiceService>();
            result.Records = new List<AccountVoiceService>();
            
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {

                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select count(0) from AccountVoiceService";
                result.RecordCount = (int)cmd.ExecuteScalar();

                cmd = conn.CreateCommand();
                cmd.CommandText = "select [ID] from(select [ID], ROW_NUMBER() OVER(ORDER BY [ID]) as [RowNum] from AccountVoiceService) as List where [RowNum] between @StartingRow and @EndingRow";
                SqlParameter startingRowParameter = cmd.Parameters.Add("@StartingRow", SqlDbType.Int);
                startingRowParameter.Value = startingRow;
                SqlParameter endingRowParameter = cmd.Parameters.Add("@EndingRow", SqlDbType.Int);
                endingRowParameter.Value = endingRow;
                
                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        int id = reader.GetInt32(0);
                        AccountVoiceService accountVoiceService = GetByID(id, false);
                        if (accountVoiceService == null)
                        {
                            throw new Exception("Unable to get account voice service: " + id.ToString());
                        }
                        result.Records.Add(accountVoiceService);
                    }
                }
            }

            return result;
        }

    }
}
