﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using Curse.Extensions;
using System.Web.Caching;

namespace Curse.Billing.Models
{
    [DataContract]
    public class Checkout
    {
        [DataMember]
        public string AccountID
        {
            get;
            set;
        }

        [DataMember]
        public DateTime Timestamp
        {
            get;
            set;
        }

        [DataMember]
        public int TransactionID
        {
            get;
            set;
        }                

        [DataMember]
        public List<ProductPurchase> PurchasedProducts
        {
            get;
            set;
        }

        [DataMember]
        public List<Subscription> PurchasedSubscriptions
        {
            get;
            set;
        }

        [DataMember]
        public AccountPaymentMethod PaymentMethod
        {
            get;
            set;
        }

        [DataMember]
        public decimal SubTotal
        {
            get;
            set;
        }

        [DataMember]
        public decimal Tax
        {
            get;
            set;
        }

        [DataMember]
        public decimal Total
        {
            get;
            set;
        }

        [DataMember]
        public string PayPalRedirectUrl
        {
            get;
            set;
        }

        public Checkout()
        {
            PurchasedProducts = new List<ProductPurchase>();
            PurchasedSubscriptions = new List<Subscription>();
            Timestamp = DateTime.UtcNow;
        }

        private const string CacheKey = "CheckoutByID-{0}";

        public void Save(int transactionID, string accountid)
        {
            this.TransactionID = transactionID;
            this.AccountID = accountid;

            HttpRuntime.Cache.Insert(CacheKey.FormatWith(this.TransactionID), this, null, DateTime.UtcNow.AddHours(1), Cache.NoSlidingExpiration);
        }

        public static Checkout GetByID(int id)
        {

            var checkout = HttpRuntime.Cache.Get(CacheKey.FormatWith(id));
            return checkout as Checkout;
        }
        
    }
}
