﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using Curse.Extensions;
using Curse.Billing.Extensions;
using System.Data.SqlClient;
using Curse.Billing.Configuration;
using System.Data;

namespace Curse.Billing.Models
{
    [DataContract]
    public class CobaltInstance
    {
        #region Properties

        [DataMember]
        public int ID { get; set; }

        [DataMember]
        public string Name { get; set; }

        #endregion

        public CobaltInstance() { }

        public CobaltInstance(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            Name = reader.GetString(1);
        }

        #region Cache Access

        public static List<CobaltInstance> GetAll()
        {
            IEnumerable<int> ids = HttpRuntime.Cache.Get("CobaltInstance-All", () =>
                GetAllIDsFromDatabase()
            );
            return GetAllByIDs(ids);
        }

        public static List<CobaltInstance> GetAllByIDs(IEnumerable<int> ids)
        {
            List<CobaltInstance> instances = new List<CobaltInstance>();
            foreach (int id in ids)
            {
                CobaltInstance CobaltInstance = GetByID(id);
                if (CobaltInstance != null)
                {
                    instances.Add(CobaltInstance);
                }
            }

            return instances;
        }

        public static CobaltInstance GetByID(int id)
        {
            return GetByID(id, false);
        }
        public static CobaltInstance GetByID(int id, bool bypassCache)
        {
            return HttpRuntime.Cache.Get(bypassCache, "CobaltInstanceByID-{0}".FormatWith(id), () =>
            {
                return GetFromDatabaseByID(id);
            });                       
        }

        #endregion

        #region Database Access

        private static CobaltInstance GetFromDatabaseByID(int id)
        {
            CobaltInstance instance = null;
            List<AccountEntitlement> entitlements = new List<AccountEntitlement>();
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select * from CobaltInstance where ID = @ID";
                SqlParameter accountIDParameter = cmd.Parameters.Add("@ID", SqlDbType.Int);
                accountIDParameter.Value = id;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    if (reader.Read())
                    {
                        instance = new CobaltInstance(reader);
                    }
                }
            }

            return instance;
        }

        private static IEnumerable<int> GetAllIDsFromDatabase()
        {
            List<int> ids = new List<int>();

            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select id from CobaltInstance";

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        ids.Add(reader.GetInt32(0));
                    }
                }
            }

            return ids;
        }

        #endregion
    }
}
