﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using System.Data.SqlClient;
using System.Data;

using Curse.Extensions;
using Curse.Billing.Configuration;
using Curse.Billing.Extensions;


namespace Curse.Billing.Models
{
    [DataContract]
    public class CouponType
    {

        [DataMember]
        public int ID
        {
            get;
            set;
        }        

        [DataMember]
        public string Prefix
        {
            get;
            set;
        }

        [DataMember]
        public string Name
        {
            get;
            set;
        }

        [DataMember]
        public string Description
        {
            get;
            set;
        }
       

        public CouponType() { }

        public CouponType(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);            
            Prefix = reader.GetString(1);
            Name = reader.GetString(2);
            Description = reader.GetString(3);
        }

        public static CouponType GetByID(int id)
        {

            return HttpRuntime.Cache.Get("CouponTypeByID-{0}".FormatWith(id), () =>
            {
                return GetFromDatabaseByID(id);
            });      
            
        }

        private static CouponType GetFromDatabaseByID(int id)
        {
            CouponType couponType = null;
            
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select * from CouponType where ID = @ID";
                SqlParameter param = cmd.Parameters.Add("@ID", SqlDbType.Int);
                param.Value = id;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    if (reader.Read())
                    {
                        couponType = new CouponType(reader);
                    }
                }
            }            

            return couponType;
        }
                
    }
}
