﻿using System;
using System.Runtime.Serialization;
using System.Data.SqlClient;

namespace Curse.Billing.Models
{
    public class Currency
    {
        [DataMember]
        public int CurrencyID { get; set; }

        [DataMember]
        public string Abbreviation { get; set; }

        [DataMember]
        public string Description { get; set; }

        [DataMember]
        public bool IsAccepted { get; set; }

        [DataMember]
        public bool IsDefault { get; set; }

        public Currency() { }
        public Currency(SqlDataReader reader)
        {
            this.CurrencyID = reader.GetInt32(reader.GetOrdinal("ID"));
            this.Abbreviation = reader.GetString(reader.GetOrdinal("Abbreviation"));
            this.Description = reader.GetString(reader.GetOrdinal("Description"));
            this.IsAccepted = reader.GetBoolean(reader.GetOrdinal("IsAccepted"));
            this.IsDefault = reader.GetBoolean(reader.GetOrdinal("IsDefault"));
        }
    }
}
