﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;

namespace Curse.Billing.Models
{
    [DataContract]
    public class ProductPurchase
    {
        [DataMember]
        public ProductPurchaseStatus Status
        {
            get;
            set;
        }

        [DataMember]
        public decimal Price
        {
            get;
            set;
        }

        [DataMember]
        public int Quantity
        {
            get;
            set;
        }

        [DataMember]
        public decimal SubTotal
        {
            get;
            set;
        }
              
        [DataMember]
        public string ProductDescription
        {
            get;
            set;
        }

        [DataMember]
        public string PlanDescription
        {
            get;
            set;
        }

        [DataMember]
        public string Message
        {
            get;
            set;
        }

        [DataMember]
        public IEnumerable<ProductFulfillment> Fulfillments
        {
            get;
            set;
        }

        public ProductPurchase() { }

        public ProductPurchase(ProductPurchaseStatus status)
        {
            this.Status = status;            
        }

        public ProductPurchase(ProductPurchaseStatus status, string message)
        {
            this.Status = status;
            this.Message = message;
        }
    }
}
