﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Billing.Models
{
    public enum ServiceResponseStatus
    {        
        Successful = 1,
        KnownException,
        UnknownException,
        AccountNotFound,

        GetCheckout_CheckoutNotFound,
        GetCheckout_IncorrectAccount,

        // Coupon Claims
        ClaimCoupon_CodeNotFound,
        ClaimCoupon_CodeAlreadyClaimed,
        ClaimCoupon_CodeExpired,
        ClaimCoupon_UnableToCreditSubscription,
        
        // Product Offering
        GetProductOffering_UnknownProductID,

        // Product Billing Plan
        GetProductBillingPlan_UnknownBillingPlanID,

        // Shopping Cart
        PurchaseProducts_InvalidItems,        
        PurchaseProducts_PaymentFailed,
        PurchaseProducts_PaymentMethodNotFound,
        PurchaseProducts_PaymentPending,
        PurchaseProducts_UnknownCountry,
        PurchaseProducts_InvalidCountryPaymentMethod,
        PurchaseProducts_InvalidCountryCurrency,

        // Change Subscription Plan
        ChangeSubscriptionPlan_PaymentMethodNotFound,
        ChangeSubscriptionPlan_SubscriptionNotFound,
        ChangeSubscriptionPlan_PaymentFailed,
        ChangeSubscriptionPlan_PaymentPending,
        ChangeSubscriptionPlan_UnknownCountry,
        ChangeSubscriptionPlan_InvalidCountryPaymentMethod,
        ChangeSubscriptionPlan_InvalidCountryCurrency,

        // Cancel Subscription        
        CancelSubscription_SubscriptionNotFound,
        CancelSubscription_SubscriptionNotActive,

        // Credit Subscription
        CreditSubscription_SubscriptionNotFound,
        CreditSubscription_SubscriptionNotActive,

        // Issue Refund
        IssueRefund_TransactionNotFound,
        IssueRefund_InvalidAmount,
        IssueRefund_AlreadyRefunded,

        // Add Account Voice Service
        AddAccountVoiceClient_ServiceAlreadyExists,
        AddAccountVoiceClient_ClientIDMismatch,

        DeleteAccountVoiceService_ClientNotFound,
        DeleteAccountVoiceService_ServiceNotFound,

        UpdateAccountVoiceService_ClientNotFound,
        UpdateAccountVoiceService_ServiceNotFound,

        FinalizePayPalTransaction_TransactionNotFound,
        FinalizePayPalTransaction_TransactionAlreadyFinalized,
        FinalizePayPalTransaction_UnableToCapture,
        FinalizePayPalTransaction_CartNotFound,

        CreditTokens_InvalidTokenAmount





    }
}
