﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;

namespace Curse.Billing.Models
{
    [DataContract]
    public class ShoppingCartItem
    {
        [DataMember]
        public string ProductID
        {
            get;
            set;
        }

        private string _billingPlanID;

        [DataMember]
        public string BillingPlanID
        {
            get
            {                
                return _billingPlanID;                
            }
            set
            {
                _billingPlanID = value;
            }
        }

        [DataMember]
        public int Quantity
        {
            get;
            set;
        }

        [DataMember]
        public DateTime? SubscriptionStartDate
        {
            get;
            set;
        }   

        public decimal GetSubTotal(CurrencyType currency)
        {                        
            return this.GetPrice(currency) * Quantity;            
        }        

        /// <summary>
        /// Returns the price of a billing plan, depending on the subscription start date
        /// and whether or not it is for display, or initial charge calculation.
        /// </summary>
        /// <param name="currency"></param>
        /// <returns></returns>
        public decimal GetPrice(CurrencyType currency)
        {

            if (this.SubscriptionStartDate.HasValue)
            {
                return 0;
            }

            ProductBillingPlan plan = ProductBillingPlan.GetByID(BillingPlanID);
            ProductPrice price = plan.GetPrice(currency);
            return price.Amount;            
        }

        public ShoppingCartItem() { }

        public ShoppingCartItem(string productID, string billingPlanID, int quantity)
        {
            this.ProductID = productID;
            this.BillingPlanID = billingPlanID;
            this.Quantity = quantity;
        }

        

    }
}
