﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using Curse.Extensions;
using Curse.Billing.Extensions;
using System.Data.SqlClient;
using Curse.Billing.Configuration;
using System.Data;
using System.Data.SqlClient;

namespace Curse.Billing.Models
{
    [DataContract]
    public class User
    {

        [DataMember]
        public int UserID { get; set; }

        public User() { }


        public User(SqlDataReader reader)
        {
            UserID = (int)reader["UserID"];
        }


        public static string GetUserBySubscriptionID(string subscriptionID)
        {
            User instance = null;
            using (SqlConnection conn = DatabaseConfiguration.GetBillingConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "SELECT distinct(UserID) FROM [BillingService_Test].[dbo].[AccountTransaction] a, [BillingService_Test].[dbo].[Subscription] b where a.PaymentMethodID = b.PaymentMethodID and b.SubscriptionID = @ID and a.UserID <> 0";
                SqlParameter accountIDParameter = cmd.Parameters.AddWithValue("@ID", subscriptionID);
                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    if (reader.Read())
                    {
                        instance = new User(reader);
                    }
                }
            }

            return instance.UserID.ToString();
        }


    }


}