﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Vindicia;
using Curse.Extensions;
using Curse.Billing.Data;
using Curse.Billing.Models;

namespace Curse.Billing.Extensions
{
    public static class AccountExtensions
    {
        public static bool SaveActivityNote(this Account account, string note)
        {            
            try
            {
                Activity activity = new Activity();
                activity.account = new Account() { merchantAccountId = account.merchantAccountId };
                activity.activityType = ActivityType.Note;

                ActivityNote activityNote = new ActivityNote();
                activityNote.note = note;

                ActivityTypeArg activityTypeArg = new ActivityTypeArg();
                activityTypeArg.noteArgs = activityNote;

                activity.activityArgs = activityTypeArg;                
                activity.timestamp = DateTime.UtcNow;
                Return r = activity.record(new Activity[] { activity });
                return (r.returnCode == ReturnCode.Item200);
            }
            catch
            {
                return false;
            }
            
        }


        public static AutoBill[] GetAutoBills(this Account account)
        {
            return Retrieval.GetAllAutoBillsByAccountID(account.merchantAccountId);
        }

        public static Entitlement[] GetEntitlements(this Account account)
        {
            return Retrieval.GetAllEntitlementsByAccountID(account.merchantAccountId, true);
        }
 
    }
}
