﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Billing.Models;
using Curse.Extensions;
using Vindicia;

namespace Curse.Billing.VindiciaExtensions
{
    public static class AutoBillStatusExtensions
    {

        public static SubscriptionStatus ToCurse(this AutoBillStatus value)
        {
            switch (value)
            {
                case AutoBillStatus.Active:
                    return SubscriptionStatus.Active;

                case AutoBillStatus.Cancelled:
                    return SubscriptionStatus.Cancelled;

                case AutoBillStatus.PendingCustomerAction:
                    return SubscriptionStatus.PendingCustomerAction;

                case AutoBillStatus.Suspended:
                    return SubscriptionStatus.Suspended;

                case AutoBillStatus.Upgraded:
                    return SubscriptionStatus.Upgraded;

                default:
                    throw new NotImplementedException("Unknown subscription status: {0}".FormatWith(value));

            }
        }
    }
}
