﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Vindicia;

using Curse.Extensions;
using Curse.Billing.Extensions;
using Curse.Billing.Data;

namespace Curse.Billing.Extensions
{
    public static class ProductExtensions
    {

        public static BillingPlan[] GetBillingPlans(this Product product)
        {
            return HttpRuntime.Cache.Get("ProductBillingPlansByID-{0}".FormatWith(product.merchantProductId), () => 
            {                    
                BillingPlan[] allPlans = HttpRuntime.Cache.Get("AllBillingPlans", () => Retrieval.GetAllBillingPlans());                    
                return allPlans.Where(p => p.status == BillingPlanStatus.Active && p.nameValues != null && p.nameValues.Any(q => q.name == "ParentProduct" && q.value == product.merchantProductId)).ToArray();                    
            });            
        }

    }
}
