﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;

namespace Curse.Caching
{
    public class ClusterMember
    {
        public ClusterMember()
        {
            
        }

        public ClusterMember(SqlDataReader reader)
        {
            ID = (int)reader["ID"];
            ApplicationIdentity = (string)reader["ApplicationIdentity"];
            HostName = (string)reader["HostName"];
            Port = (int)reader["Port"];
        }

        public int ID { get; set; }
        public string ApplicationIdentity { get; set; }
        public string HostName { get; set; }
        public int Port { get; set; }

        public void Save(SqlConnection conn)
        {
            SqlCommand cmd = conn.CreateCommand();
            cmd.CommandText = "INSERT INTO ClusterMember(ApplicationIdentity, HostName, Port) OUTPUT INSERTED.ID VALUES(@ApplicationIdentity, @HostName, @Port)";
            cmd.Parameters.AddWithValue("@ApplicationIdentity", ApplicationIdentity);
            cmd.Parameters.AddWithValue("@HostName", HostName);
            cmd.Parameters.AddWithValue("@Port", Port);
            ID = (int)cmd.ExecuteScalar();
        }
    }
}
