var appLauncher = {
	launchUrl: null,
	getUrl: function () {
		return this.launchUrl;
	},
	launch: function (url,callbackMethod) {
	    this.launchUrl = url;

		if ($.browser.mozilla) {
		    this.launchMozilla(callbackMethod);
		} else if ($.browser.chrome) {
		    this.launchChrome(callbackMethod);
		} else if ($.browser.safari) {
		    this.launchChrome(callbackMethod);
		} else if ($.browser.msie) {
		    this.launchIE(callbackMethod);
		}
	},
	launchChrome: function (callbackMethod) {

	    $("body").append('<input id="appLauncherProtocol" value="" style="opacity:0"/>');

	    var url = this.getUrl(),
		    protcolEl = $('#appLauncherProtocol')[0];

		var isSupported = false;

		protcolEl.focus();
		protcolEl.onblur = function () {
		    isSupported = true;
		};

		//will trigger onblur
		location.href = url;

		setTimeout(function () {
		    protcolEl.onblur = null;
		    if (callbackMethod) {
		        callbackMethod(isSupported);
		    }
		}, 300);
	},
	launchMozilla: function (callbackMethod) {

	    $("body").append('<iframe id="appLauncherHiddenIframe" src="about:blank" style="display:none;"></iframe>');

	    var url = this.getUrl(),
            iFrame = $('#appLauncherHiddenIframe')[0];

	    var isSupported = false;

	    //Set iframe.src and handle exception
	    try {
	        iFrame.contentWindow.location.href = url;
	        isSupported = true;
	        if (callbackMethod) {
	            callbackMethod(isSupported);
	        }
	    } catch (e) {
	        //FireFox
	        if (e.name == "NS_ERROR_UNKNOWN_PROTOCOL") {
	            isSupported = false;
	            if (callbackMethod) {
	                callbackMethod(isSupported);
	            }
	        }
	    }
	},
	launchIE: function (callbackMethod) {
	    var url = this.getUrl();

	    var isSupported = false;

	    // Case 1: IE10+
	    if (navigator.msLaunchUri) {
	        navigator.msLaunchUri(url,
                   function () { isSupported = true; if (callbackMethod) { callbackMethod(isSupported); } }, //success
                   function () { isSupported = false; if (callbackMethod) { callbackMethod(isSupported); } }  //failure
            );
	        return;
	    }

	    isSupported = false;
	    if (callbackMethod) {
	        callbackMethod(isSupported);
	    }
	}
}