﻿using System;
using System.Configuration;
using Curse.Logging;
using Curse.Logging.Uploader;

namespace Curse.Radon.AddonServer
{
    public class Global : System.Web.HttpApplication
    {

        protected void Application_Start(object sender, EventArgs e)
        {
            Logger.Init(ConfigurationManager.AppSettings["LogPath"], "AddonServer");            
            LogUploader.Initialize(10, ConfigurationManager.AppSettings["LogServiceUrl"], ConfigurationManager.AppSettings["LogServiceApiKey"]);
            Logger.Info("Service Started");
        }

        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {
            Logger.Info("Service Ended");
            Logger.Shutdown();

        }
    }
}