﻿using System.Configuration;

namespace Curse.Radon.DownloadTracker.Configuration
{
	public class DownloadTrackerConfiguration : ConfigurationSection
	{
		public enum ConfigurationMode
		{
			Development,
			Staging,
			Production
		}
		private static readonly ConfigurationMode _activeConfiguration;
		private static readonly string _activeConfigurationName;

		private static readonly DownloadTrackerConfiguration _instance = ConfigurationManager.GetSection("curse/downloadTracker") as DownloadTrackerConfiguration;
		public static DownloadTrackerConfiguration Instance
		{
			get
			{
				return _instance;
			}
		}
		static DownloadTrackerConfiguration()
        {

#if CONFIG_DEBUG
            _activeConfiguration = ConfigurationMode.Development;
#elif CONFIG_STAGING
            _activeConfiguration = ConfigurationMode.Staging;
#elif CONFIG_RELEASE
            _activeConfiguration = ConfigurationMode.Production;
#endif
            _activeConfigurationName = _activeConfiguration.ToString().ToLower();

        }

		public DownloadTrackerConfiguration() { }

		public static ConfigurationMode ActiveConfiguration
		{
			get
			{
				return _activeConfiguration;
			}
		}

		public static string ActiveConfigurationName
		{
			get
			{
				return _activeConfigurationName;
			}
		}

		[ConfigurationProperty("database", IsRequired = true)]
		[ConfigurationCollection(typeof(ConnectionStringsElementCollection), AddItemName = "dataProvider")]
		public ConnectionStringsElementCollection ConnectionStrings
		{
			get { return this["database"] as ConnectionStringsElementCollection; }
		}

		public static ConnectionStringConfigElement Database
		{
			get
			{
				return Instance.ConnectionStrings.Active;
			}
		}

		public static string ConnectionString
		{
			get
			{
				return Instance.ConnectionStrings.Active.ConnectionString;
			}
		}
	}

	public class ConnectionStringsElementCollection : ConfigurationElementCollection
	{
		public DownloadTrackerConfiguration this[int index]
		{
			get
			{
				return base.BaseGet(index) as DownloadTrackerConfiguration;
			}
			set
			{
				if (base.BaseGet(index) != null)
				{
					base.BaseRemoveAt(index);
				}
				this.BaseAdd(index, value);
			}
		}

		protected override ConfigurationElement CreateNewElement()
		{
			return new ConnectionStringConfigElement();
		}

		protected override object GetElementKey(ConfigurationElement element)
		{
			return ((ConnectionStringConfigElement)element).Key;
		}

		public ConnectionStringConfigElement Active
		{
			get
			{
				if (_active == null)
				{
					foreach (ConnectionStringConfigElement key in this)
					{
						if (key.Key == DownloadTrackerConfiguration.ActiveConfigurationName)
						{
							_active = key;
							break;
						}
					}
				}
				return _active;
			}
		}
		private ConnectionStringConfigElement _active;
	}

	public class ConnectionStringConfigElement : ConfigurationElement
	{
		public ConnectionStringConfigElement() { }

		public ConnectionStringConfigElement(string key, string value)
		{
			Key = key;
			ConnectionString = value;
		}

		[ConfigurationProperty("key", IsKey = true, IsRequired = true)]
		public string Key
		{
			get
			{
				return (string)this["key"];
			}
			internal set
			{
				this["key"] = value;
			}
		}

		[ConfigurationProperty("connectionString", IsRequired = true)]
		public string ConnectionString
		{
			get
			{
				return (string)this["connectionString"];
			}
			internal set
			{
				this["connectionString"] = value;
			}
		}

		[ConfigurationProperty("loggingEnabled", IsRequired = true)]
		public bool LoggingEnabled
		{
			get
			{
				return (bool)this["loggingEnabled"];
			}
			internal set
			{
				this["loggingEnabled"] = value;
			}
		}

		[ConfigurationProperty("writeRestTimeSeconds", IsRequired = true)]
		public int WriteRestTimeSeconds
		{
			get
			{
				return (int)this["writeRestTimeSeconds"];
			}
			internal set
			{
				this["writeRestTimeSeconds"] = value;
			}
		}

        [ConfigurationProperty("redirectUrl", IsRequired = true)]
        public string RedirectUrl
        {
            get
            {
                return (string)this["redirectUrl"];
            }
            internal set
            {
                this["redirectUrl"] = value;
            }
        }
	}
}
