﻿using System;
using System.Net;

namespace Curse.Radon.DownloadTracker
{
    public class TrackedDownload
    {
        public TrackedDownload(IPAddress ip, int fileID, string referrer, string userAgent, int? packFileID)
        {
            DateDownloaded = DateTime.UtcNow;
            IPAddress = ip;
            FileID = fileID;
            Referrer = referrer;
            UserAgent = userAgent;
            PackFileID = packFileID;            
        }

        public IPAddress IPAddress { get; private set; }
        public int FileID { get; private set; }
        public DateTime DateDownloaded { get; private set; }
        public string Referrer { get; private set; }
        public string UserAgent { get; private set; }
        public int? PackFileID { get; private set; }        
    }
}
