﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;




namespace Curse.WAR
{
    public sealed class Ability
         : IPackable
    {

        public Byte Category = 0;
        public Byte RequiredRank = 0;
        public Byte RequiredRenown = 0;        
        public Int32 PackageId = 0;
        public Int32 UselessCareerId = 0;
        public UInt16 ReuseTimer = 0;
        public Byte StanceOrder = 0;
        public Byte TargetType = 0;
        public Byte IsHealing = 0;
        public Byte IsBuff = 0;
        public Byte IsStatsBuff = 0;
        public Byte IsOffensive = 0;
        public Byte Specialization = 0;
        public Byte TacticSlots = 0;
        public Byte IsGranted = 0;
        public Byte RequiresPet = 0;
        public Byte Type = 0;
        public Byte IsDefensive = 0;
        public Byte UselessReuseTimer = 0;
        public Int32 Icon = 0;
        public Byte ImprovementThreshold = 0;
        public Byte IsDebuff = 0;
        public Int32 Id = 0;
        public UInt16 CostMorale = 0;
        public Int16 CostUnknown = 0;
        public Byte HasCostPerSecond = 0;
        public Byte ImprovementCap = 0;
        public Byte IsDamaging = 0;
        public EntityName Name = new EntityName();
        public Byte MoraleLevel = 0;
        public Byte TacticType = 0;
        public UInt16 CastTime = 0;
        public Int32 Cooldown = 0;
        public Byte IsPassive = 0;        
        public Byte Tier = 0;
        public Byte CostRenown = 0;        
        public Int32 CostCoin = 0;
        public Byte MaxPurchaseCount = 0;
        public Int32 AdvanceId = 0;
        public Byte CareerId = 0;        
        public PackableList<AbilityDescription> Descriptions = new PackableList<AbilityDescription>();
        public Byte CostAction = 0;
        public PackableList<AbilityDependency> Dependencies = new PackableList<AbilityDependency>();
        public Byte Level = 0;
        public UInt16 RangeMin = 0;
        public UInt16 RangeMax = 0;
        public PackableList<AbilityRequirement> Requirements = new PackableList<AbilityRequirement>();

        public Byte IsHex = 0;
        public Byte IsCurse = 0;
        public Byte IsCripple = 0;
        public Byte IsAilment = 0;
        public Byte IsBolster = 0;
        public Byte IsAugmentation = 0;
        public Byte IsBlessing = 0;
        public Byte IsEnchantment = 0;
        public Byte RequiredCategoryPoints = 0;

        public Boolean Read(IReadable pBuf)
        {
            bool ok = pBuf.Read(ref Category) &&
                pBuf.Read(ref RequiredRank) &&
                pBuf.Read(ref RequiredRenown) &&                
                pBuf.Read(ref PackageId) &&
                pBuf.Read(ref UselessCareerId) &&
                pBuf.Read(ref ReuseTimer) &&
                pBuf.Read(ref StanceOrder) &&
                pBuf.Read(ref TargetType) &&
                pBuf.Read(ref IsHealing) &&
                pBuf.Read(ref IsBuff) &&
                pBuf.Read(ref IsStatsBuff) &&
                pBuf.Read(ref IsOffensive) &&
                pBuf.Read(ref Specialization) &&
                pBuf.Read(ref TacticSlots) &&
                pBuf.Read(ref IsGranted) &&
                pBuf.Read(ref RequiresPet) &&
                pBuf.Read(ref Type) &&
                pBuf.Read(ref IsDefensive) &&
                pBuf.Read(ref UselessReuseTimer) &&
                pBuf.Read(ref Icon) &&
                pBuf.Read(ref ImprovementThreshold) &&
                pBuf.Read(ref IsDebuff) &&
                pBuf.Read(ref Id) &&
                pBuf.Read(ref CostMorale) &&
                pBuf.Read(ref CostUnknown) &&
                pBuf.Read(ref HasCostPerSecond) &&
                pBuf.Read(ref ImprovementCap) &&
                pBuf.Read(ref IsDamaging) &&
                Name.Read(pBuf) &&
                pBuf.Read(ref MoraleLevel) &&
                pBuf.Read(ref TacticType) &&
                pBuf.Read(ref CastTime) &&
                pBuf.Read(ref Cooldown) &&
                pBuf.Read(ref IsPassive) &&                
                pBuf.Read(ref Tier) &&
                pBuf.Read(ref CostRenown) &&                
                pBuf.Read(ref CostCoin) &&
                pBuf.Read(ref MaxPurchaseCount) &&
                pBuf.Read(ref AdvanceId) &&
                pBuf.Read(ref CareerId) &&
                Descriptions.Read(pBuf) &&
                pBuf.Read(ref CostAction) &&
                Dependencies.Read(pBuf) &&
                pBuf.Read(ref Level) &&
                pBuf.Read(ref RangeMin) &&
                pBuf.Read(ref RangeMax) &&
                Requirements.Read(pBuf) &&
                pBuf.Read(ref IsHex) &&
                pBuf.Read(ref IsCurse) &&
                pBuf.Read(ref IsCripple) &&
                pBuf.Read(ref IsAilment) &&
                pBuf.Read(ref IsBolster) &&
                pBuf.Read(ref IsAugmentation) &&
                pBuf.Read(ref IsBlessing) &&
                pBuf.Read(ref IsEnchantment) &&
                pBuf.Read(ref RequiredCategoryPoints);
                
            return ok;


        }

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }
    }
}