﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.WAR
{
     public sealed class  BattlefieldStatus
          : IPackable
    {

         public Int32 ZoneId = 0;
         public UInt16 OrderControl = 0;
         public UInt16 DestructionControl = 0;
         public Byte Controller = 0;
         public Byte XpBuff = 0;
         public Byte RenownBuff = 0;
         public PackableList<BattlefieldStatusPoint> Points = new PackableList<BattlefieldStatusPoint>();
         

         public Boolean Read(IReadable pBuf)
         {
             bool ok = pBuf.Read(ref ZoneId) &&
                 pBuf.Read(ref OrderControl) &&
                 pBuf.Read(ref DestructionControl) &&
                 pBuf.Read(ref Controller) &&
                 pBuf.Read(ref XpBuff) &&
                 pBuf.Read(ref RenownBuff) &&
                 Points.Read(pBuf);
                 
             return ok;

         }

         public Boolean Write(IWriteable pBuf)
         {
             return false;
         }
    }
}
