﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.WAR
{
    public sealed class Influence
         : IPackable
    {

        public UInt16 Id = 0;
        public EntityName NPCName = new EntityName();
        public UInt16 TomeSection = 0;
        public UInt16 ZoneId = 0;
        public UInt16 TomeEntry = 0;
        public UInt16 AreaId = 0;
        public Byte IsRvR = 0;
        public PackableList<InfluenceReward> Rewards = new PackableList<InfluenceReward>();
        

        public Boolean Read(IReadable pBuf)
        {
            bool ok = pBuf.Read(ref Id) &&
                NPCName.Read(pBuf) &&
                pBuf.Read(ref TomeSection) &&
                pBuf.Read(ref ZoneId) &&
                pBuf.Read(ref TomeEntry) &&
                pBuf.Read(ref AreaId) &&
                pBuf.Read(ref IsRvR) &&
                Rewards.Read(pBuf);
                
            return ok;

        }

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }
    }
}
