﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;




namespace Curse.WAR
{
    public sealed class Item
         : IPackable
    {

        public Int32 DisplayId = 0;
        public Int32 Id = 0;
        public String Name = null;
        public String Description = null;
        public Byte Type = 0;
        public Byte Level = 0;
        public Byte ILevel = 0;
        public Byte Renown = 0;
        public Byte Rarity = 0;
        public Int32 SellPrice = 0;
        public Int32 BuyPrice = 0;
        public UInt16 ItemSet = 0;
        public Byte Binding = 0;
        public Byte StackCount = 0;
        public Byte EquipSlot = 0;
        public Byte EnchantSlots = 0;
        public Byte Charges = 0;
        public Byte CultivationType = 0;
        public UInt16 TrophyIndex = 0;
        public Byte TrophyLocation = 0;
        public UInt16 CraftingSkillRequired = 0;
        public UInt16 Speed = 0;
        public UInt16 BlockRating = 0;
        public UInt16 Icon = 0;
        public UInt16 Armor = 0;
        public UInt16 DPS = 0;
        public Byte IsQuestItem = 0;
        public PackableList<ItemFlag> Flags = new PackableList<ItemFlag>();
        public PackableByteList RequiredSkills = new PackableByteList();        
        public PackableList<ItemBonus> Bonuses = new PackableList<ItemBonus>();
        public PackableList<ItemCraftingBonus> CraftingBonuses = new PackableList<ItemCraftingBonus>();
        public PackableByteList RequiredCareers = new PackableByteList();
        public PackableByteList RequiredRaces = new PackableByteList();
        public PackableList<ItemAltCurrency> AltCurrency = new PackableList<ItemAltCurrency>();
       

        public Boolean Read(IReadable pBuf)
        {
            bool ok = pBuf.Read(ref DisplayId) &&
                pBuf.Read(ref Id) &&
                pBuf.Read(ref Name) &&
                pBuf.Read(ref Description) &&
                pBuf.Read(ref Type) &&
                pBuf.Read(ref Level) &&
                pBuf.Read(ref ILevel) &&
                pBuf.Read(ref Renown) &&
                pBuf.Read(ref Rarity) &&
                pBuf.Read(ref SellPrice) &&
                pBuf.Read(ref BuyPrice) &&
                pBuf.Read(ref ItemSet) &&
                pBuf.Read(ref Binding) &&
                pBuf.Read(ref StackCount) &&
                pBuf.Read(ref EquipSlot) &&
                pBuf.Read(ref EnchantSlots) &&
                pBuf.Read(ref Charges) &&
                pBuf.Read(ref CultivationType) &&
                pBuf.Read(ref TrophyIndex) &&
                pBuf.Read(ref TrophyLocation) &&
                pBuf.Read(ref CraftingSkillRequired) &&
                pBuf.Read(ref Speed) &&
                pBuf.Read(ref BlockRating) &&
                pBuf.Read(ref Icon) &&
                pBuf.Read(ref Armor) &&
                pBuf.Read(ref DPS) &&
                pBuf.Read(ref IsQuestItem) &&
                Flags.Read(pBuf) &&
                RequiredSkills.Read(pBuf) &&
                Bonuses.Read(pBuf) &&
                CraftingBonuses.Read(pBuf) &&
                RequiredCareers.Read(pBuf) &&
                RequiredRaces.Read(pBuf) &&
                AltCurrency.Read(pBuf);

            return ok;


        }

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }
    }
}
