﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.WAR
{
     public sealed class  NPC
          : IPackable
    {

         public EntityName Name = new EntityName();
         public UInt16 Title = 0;
         public Byte MapPinType = 0;
         public Byte MinLevel = 0;
         public Byte MaxLevel = 0;

         public PackableList<NPCHealth> Health = new PackableList<NPCHealth>();

         public Byte Type = 0;
         public Byte Tier = 0;
         public UInt16 Species = 0;
         public UInt16 SubType = 0;
	        
         public PackableList<EntityLocation> Locations = new PackableList<EntityLocation>();
         public Int32 MoneyCount = 0;
         public Int32 KillCount = 0;
         // Traditional Drops
         public Int32 LootCount = 0;
         public PackableList<EntityLoot> Loots = new PackableList<EntityLoot>();
         public PackableList<EntityLoot> QuestLoots = new PackableList<EntityLoot>();
                  
         // Scavenged Loot
         public Int32 ScavengeCount = 0;
         public PackableList<EntityLoot> ScavengedLoots = new PackableList<EntityLoot>();
         // Butchered Loot
         public Int32 ButcherCount = 0;
         public PackableList<EntityLoot> ButcheredLoots = new PackableList<EntityLoot>();
         public PackableList<NPCMerchandise> Merchandise = new PackableList<NPCMerchandise>();

         public Boolean Read(IReadable pBuf)
         {
             bool ok = Name.Read(pBuf) &&
                 pBuf.Read(ref MapPinType) &&
                 pBuf.Read(ref Title) &&
                 pBuf.Read(ref MinLevel) &&
                 pBuf.Read(ref MaxLevel) &&
                 Health.Read(pBuf) &&
                 pBuf.Read(ref Type) &&
                 pBuf.Read(ref Tier) &&
                 pBuf.Read(ref Species) &&
                 pBuf.Read(ref SubType) &&
                 Locations.Read(pBuf) &&
                 pBuf.Read(ref MoneyCount) &&
                 pBuf.Read(ref KillCount) &&
                 pBuf.Read(ref LootCount) &&
                 Loots.Read(pBuf) &&
                 QuestLoots.Read(pBuf) &&
                 pBuf.Read(ref ScavengeCount) &&
                 ScavengedLoots.Read(pBuf) &&
                 pBuf.Read(ref ButcherCount) &&
                 ButcheredLoots.Read(pBuf) &&
                 Merchandise.Read(pBuf);
             return ok;

         }

         public Boolean Write(IWriteable pBuf)
         {
             return false;
         }
    }
}
