﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.WAR
{
    public sealed class Quest
         : IPackable
    {

        public Int32 Id = 0;
        public EntityName Name = new EntityName();
        public Int16 Area = 0;
        public String JournalDescription = null;
        public String StartingDescription = null;
        public Byte Level = 0;
        public Int32 Timer = 0;
        public Int32 RewardXP = 0;
        public Int32 RewardCoin = 0;
        public EntityName StartingNPC = new EntityName();
        public Int32 PreviousQuest = 0;
        public EntityName FinishingNPC = new EntityName();

        public EntityName StartingGameObject = new EntityName();        
        public EntityName FinishingGameObject = new EntityName();        

        public PackableInt32List RewardGivenItems = new PackableInt32List();
        public PackableInt32List RewardChoiceItems = new PackableInt32List();
        public PackableByteList Types = new PackableByteList();
        public PackableUInt16List Zones = new PackableUInt16List();
        public PackableList<QuestCondition> Conditions = new PackableList<QuestCondition>();


        public Boolean Read(IReadable pBuf)
        {
            bool ok = pBuf.Read(ref Id) &&
                Name.Read(pBuf) &&
                pBuf.Read(ref Area) &&
                pBuf.Read(ref JournalDescription) &&
                pBuf.Read(ref StartingDescription) &&
                pBuf.Read(ref Level) &&
                pBuf.Read(ref Timer) &&
                pBuf.Read(ref RewardXP) &&
                pBuf.Read(ref RewardCoin) &&
                StartingNPC.Read(pBuf) &&
                pBuf.Read(ref PreviousQuest) &&
                FinishingNPC.Read(pBuf) &&
                StartingGameObject.Read(pBuf) &&
                FinishingGameObject.Read(pBuf) &&
                RewardGivenItems.Read(pBuf) &&
                RewardChoiceItems.Read(pBuf) &&
                Types.Read(pBuf) &&
                Zones.Read(pBuf) &&
                Conditions.Read(pBuf);
            
            return ok;

        }

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }
    }
}
