﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Net.Mail;
using System.Net.Mime;
using System.IO;
using System.Diagnostics;


namespace FakePayPalRevoker
{
    class Mailer
    {
        private static readonly Mailer _instance = new Mailer();

        // Templating        
        private Dictionary<string, string> _templates;
        //private Thread _templateThread;
        private ContentType _htmlMimeType = new ContentType("text/html");
        private Encoding _mailEncoding = Encoding.GetEncoding("utf-8");


        public static Mailer Instance
        {
            get
            {
                return _instance;
            }
        }

        public void SendMail(List<OffendingRecord> offendingRecords)
        {

            SmtpClient _client = new SmtpClient(Settings.Default.SMTPServer);

            MailMessage _message = new MailMessage();
            _message.To.Add(Settings.Default.NotificationEmailTo);
            _message.From = new MailAddress(Settings.Default.NotificationEmailFrom);
            _message.Subject = Settings.Default.NotificationEmailSubject;


            string htmlBody = String.Empty;
            string plainTextBody = String.Empty;



            #region HTML Body

            htmlBody = @"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'> 
                <html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>
                <head>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>
                <title>Fake Paypal Account Revoker</title>
                </head>
                <body style='font-family: verdana,arial,helvetica,sans-serif; font-size: 12px;'>
                <p>This email lists all fake paypal accounts that have been detected and subsequently revoked.</p>
                <ul>";

            foreach (OffendingRecord rec in offendingRecords)
            {
                htmlBody = htmlBody + "<li>Subscription: " + rec.SubID + " has been revoked on User: <a href='http://www.curse.com/cp/users?filter-search-by=2&filter-search-method=2&filter-search-text=" + rec.UserID + "'>" + rec.UserID + "</a></li>";
            }

            htmlBody = htmlBody + "</ul>";

            htmlBody = htmlBody + "</body></html>";

            #endregion


            #region Plain Text Body

            plainTextBody = @"This email lists all fake paypal accounts that have been detected and subsequently revoked.";

            foreach (OffendingRecord rec in offendingRecords)
            {
                plainTextBody = plainTextBody + "Subscription: " + rec.SubID + " has been revoked on User: " + rec.UserID;
            }

            #endregion



            if (!htmlBody.ToLower().StartsWith("<doctype>") && !htmlBody.ToLower().StartsWith("<html>"))
            {
                htmlBody = String.Format("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HTML><HEAD><META http-equiv=Content-Type content=\"text/html; charset=iso-8859-1\"></HEAD><BODY>{0}</BODY></HTML>", htmlBody);
            }

            _message.BodyEncoding = _mailEncoding;

            AlternateView plainView = AlternateView.CreateAlternateViewFromString(plainTextBody, _mailEncoding, "text/plain");
            _message.AlternateViews.Add(plainView);

            AlternateView htmlView = AlternateView.CreateAlternateViewFromString(htmlBody, _mailEncoding, "text/html");
            _message.AlternateViews.Add(htmlView);

            _client.Send(_message);
        }
    }
}
