﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.ServiceModel;
using Vindicia;
using System.Diagnostics;
using System.IO;

namespace FakePayPalRevoker
{
    class Program
    {
        static void Main(string[] args)
        {

            Trace.WriteLine("Beginning logging session on:" + DateTime.UtcNow.ToLongDateString() + " -- " + DateTime.UtcNow.ToLongDateString());
            //Console.WriteLine("Starting revoke session...");

            List<OffendingRecord> records = new List<OffendingRecord>();

            using (SqlConnection conn = new SqlConnection(@"Data Source=sql07-live.curse.us;MultiSubnetFailover=True;Initial Catalog=BillingService;Persist Security Info=True;Integrated Security=true;MultipleActiveResultSets=true;"))
            {
                conn.Open();

                //This query starts by getting a sub-query where a subsctiption only has two account transactions (as the rcords we are looking for are when 
                //there is only a CUTXN transaction for paypal stuck at Pending (Status = 9) and a CUAB transaction on the subscription that Vindicia has set to Cancelled (status = 5)).
                //We then Inner join that result set onto the same table and filter it down to only those rows whose status equals 5 or 9.
                //Then we left join that result set onto AccountEntitlement to make sure that the user's (AccountID) has Entitlements greater than today. 
                //We look back at subscriptions that started up to 420 days ago to make sure we capture all 12-month subscription types.

                SqlCommand cmd = conn.CreateCommand();
                cmd.Connection = conn;
                cmd.CommandTimeout = 600;
                cmd.CommandText = @"select b.subscriptionid, b.userid from subscriptionhistory as b 
                                    inner join
                                    (
                                    select a.accountid, a.paymentmethodid
                                    from accounttransaction as a
                                    inner join(
                                    select accountid, count(*) GroupCount from accounttransaction group by accountid having count(*) = 2
                                    ) g
                                    on a.AccountID = g.AccountID
                                    where a.Status in (5, 9)
                                    group by a.accountid, a.paymentmethodid, g.GroupCount
                                    having count(*) = g.GroupCount) h
                                    on b.PaymentMethodID = h.PaymentMethodID
                                    left join AccountEntitlement as c
                                    on b.entitledaccountid = c.accountid
                                    where b.productid = 'CP' and b.timestamp > GETUTCDATE() -420 and c.dateexpires > GETUTCDATE()
                                    order by b.Timestamp desc";

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        OffendingRecord r = new OffendingRecord();
                        r.SubID = reader.GetString(0);
                        r.UserID = reader.GetInt32(1);
                        records.Add(r);
                    }
                }

                conn.Close();
            }

          
            VindiciaConfiguration.Initialize();

            int totalRecordsToProcess = records.Count;
            Console.WriteLine("Records to process: " + totalRecordsToProcess.ToString());
            int counter = 0;

            foreach (OffendingRecord rec in records)
            {
                counter++;
                AutoBill ab = new AutoBill() { merchantAutoBillId = rec.SubID };
                Return r = ab.cancel(true, false);

                Trace.WriteLine("Terminate Entitlements for SubscriptionId:\t" + rec.SubID + "\t for user:\t" + rec.UserID + "\tWas:\t" + r.returnCode);
#if debug
                Console.WriteLine("Terminate Entitlements for SubscriptionId: " + rec.SubID + " for user: " + rec.UserID + " Was:" + r.returnCode);
                Console.WriteLine("Processed " + counter.ToString() + " of " + totalRecordsToProcess.ToString() + " records.");
#endif
            }

            if (FakePayPalRevoker.Settings.Default.EnableEmailNotifications)
            {
                Mailer.Instance.SendMail(records);
            }

            Trace.WriteLine("Completed processing accounts on:" + DateTime.UtcNow.ToShortDateString() + " -- " + DateTime.UtcNow.ToLongDateString());
#if debug   
            Console.WriteLine("Completed processing accounts.");
            Console.ReadKey();
#endif
        }
    }
}
