﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class CAddOnFileDependency : INotifyPropertyChanged
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        [DataMember]        
        public int AddOnId
        {
            get;
            set;
        }

        [DataMember]
        public EDependencyType Type
        {
            get;
            set;
        }
       
        public CAddOnFileDependency()
        {
        }

        public CAddOnFileDependency(int pProjectId, byte pDependencyType)
        {
            AddOnId = pProjectId;
            Type = (EDependencyType)pDependencyType;                        
        }
    }
}
