﻿using Curse;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Net;
using System.Security.Cryptography;
using System.Text;
using System.Threading;
using System.Configuration;
using System.Web.Services;
using System.Web;

namespace Curse.Auth
{
    /**
     * Class used to handle user and session validation with the central authentication service
     * Internally handles session management
     * Intended to be shared among all services to provide a unified and redundant architecture for validation
     * Session expiration should be short, long enough to handle a sequence of requests based on needs of each service
     * The authentication service maintains long term session keys, and will expire them when passwords change
     *
     * @author Michael Comperda
     */
    public class EncryptionProvider
    {          
        private Int32 _siteID = 0;
        private StringCipher _cipher = null;
                        
        public int SiteID
        {
            get
            {
                return _siteID;
            }
        }

        public EncryptionProvider(Int32 siteID, String siteKey)
        {            
            Debug.Assert(siteID > 0);
            Debug.Assert(siteKey != null);
                        
            _siteID = siteID;
            _cipher = new StringCipher(siteKey);            
        }

        public EncryptionProvider(Int32 siteID, byte[] siteKey)
        {
            Debug.Assert(siteID > 0);
            Debug.Assert(siteKey != null);

            _siteID = siteID;
            _cipher = new StringCipher(siteKey);
        }
        
        public string EncryptPassword(string password)
        {
            return _cipher.Encrypt(password);
        }                

    }
}
