﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Web;
using Curse.Logging;
using Curse.Logging.Uploader;


namespace Curse.Auth
{
    public static class HttpRequestExtensions
    {

        private static IPAddress GetClientIPAddress(string ipString, bool silentFailure)
        {
            if (ipString.Contains(","))
            {
                string[] ipArray = ipString.Split(',');
                ipString = ipArray[ipArray.Length - 1].Trim();
            }

            IPAddress ipAddress;
            if (IPAddress.TryParse(ipString, out ipAddress))
            {
                return ipAddress;
            }
            else if (silentFailure)
            {
                return null;
            }
            else
            {
                throw new InvalidOperationException(string.Format("Cannot parse IPAddress '{0}'", ipString));
            }
        }

        public static IPAddress GetClientIPAddress(this HttpRequest request)
        {
            return GetClientIPAddress(request, false);
        }

        public static IPAddress GetClientIPAddress(this HttpRequest request, bool silentFailure)
        {
            string ipAddress = null;
            try
            {
                ipAddress = request.Headers["X-Forwarded-For"];                
            }
            catch
            {
                
            }
            if (string.IsNullOrEmpty(ipAddress))
            {                
                ipAddress = request.UserHostAddress;
            }

            Logger.Info("IP Address: " + ipAddress);

            return GetClientIPAddress(ipAddress, silentFailure);
        }
    }
}
