﻿using System;
using Curse.Azeroth.Models.Extensions;

namespace Curse.Azeroth.Models.WoW
{
    public enum CurrencyType
    {
        UNKNOWN = 0,
        COPPER = 1,
        EXTENDED
    }
    public enum DropType
    {
        UNKNOWN = 0,
        ITEM = 1,
        MONEY,
        CURRENCY
    }
    public enum DropSourceType
    {
        UNKNOWN = 0,
        NPC = 1,
        HERB_GATHERING,
        MINING,
        OPENING,
        SKINNING,
        PICK_POCKET,
        SEARCHING_FOR_ARTIFACTS,
        FISHING,
        ENCHANTING
    }
    public sealed class Drop
    {
        public int DropId { get; set; }
        public DropType DropType { get; set; }
        public CurrencyType CurrencyType { get; set; }
        public int Quantity { get; set; }
        public bool Valid { get; set; }

        public Drop(string dropString)
        {
            var dropData = dropString.ColonDelimited();

            switch (dropData[0].ToUpper())
            {
                case "MONEY":
                    DropType = DropType.MONEY;
                    CurrencyType = CurrencyType.COPPER;
                    Quantity = int.Parse(dropData[1]);
                    Valid = true;

                    break;
                default:
                    int itemId = 0;
                    if (int.TryParse(dropData[0], out itemId))
                    {
                        DropId = itemId;
                        DropType = DropType.ITEM;
                        Quantity = int.Parse(dropData[1]);
                        Valid = true;
                    }
                    break;
            }
        }
    }
}
