﻿using System;
using LuaSerialization;
using System.Collections.Generic;
using Curse.Azeroth.Models.Extensions;

namespace Curse.Azeroth.Models.WoW
{
    public enum InstanceType
    {
        UNKNOWN = 0,
        NONE = 1,
        PARTY,
        RAID,
        PVP,
        ARENA
    }
    public enum InstanceDifficulty
    {
        UNKNOWN = 0,
        NONE,
        PARTY,
        PARTY_HEROIC
    }

    public class InstanceInfo
    {
        public InstanceType InstanceType { get; set; }
        public InstanceDifficulty InstanceDifficulty { get; set; }
        public bool DynamicDifficulty { get; set; }

        public List<NpcStats> Stats = new List<NpcStats>();
        public List<Drop> Drops = new List<Drop>();
        public List<int> SpellIds = new List<int>();
        public List<Location> Locations = new List<Location>();

        public InstanceInfo(string instanceString)
        {
            var instanceData = instanceString.ColonDelimited();
            // Instance Type
            switch (instanceData[0].ToUpper())
            {
                case "NONE":
                    this.InstanceType = InstanceType.NONE;
                    break;
                case "PARTY":
                    this.InstanceType = InstanceType.PARTY;
                    break;
                case "RAID":
                    this.InstanceType = InstanceType.RAID;
                    break;
                case "PVP":
                    this.InstanceType = InstanceType.PVP;
                    break;
                case "ARENA":
                    this.InstanceType = InstanceType.ARENA;
                    break;
                default:
                    this.InstanceType = InstanceType.UNKNOWN;
                    break;
            }

            // Instance Difficulty
            switch (instanceData[1].ToUpper())
            {
                case "NONE":
                    this.InstanceDifficulty = InstanceDifficulty.NONE;
                    break;
                case "5_PLAYER":
                    this.InstanceDifficulty = InstanceDifficulty.PARTY;
                    break;
                case "5_PLAYER(HEROIC)":
                    this.InstanceDifficulty = InstanceDifficulty.PARTY_HEROIC;
                    break;
                default:
                    this.InstanceDifficulty = InstanceDifficulty.UNKNOWN;
                    break;
            }

            // Dynamic Difficulty
            this.DynamicDifficulty = bool.Parse(instanceData[2]);
        }
    }
    
    public class InstanceData
    {
        [LuaField("locations")]
        public Dictionary<string, LocationStore> Locations = new Dictionary<string, LocationStore>();

        [LuaField("fishing_locations")]
        public Dictionary<string, Dictionary<string, FishingStoreData>> FishingLocations = new Dictionary<string,Dictionary<string,FishingStoreData>>();
        
        [LuaField("drops")]
        public string[] Drops { get; set; }

        [LuaField("stats")]
        public Dictionary<string, StatData> Stats = new Dictionary<string, StatData>();

        [LuaField("spells")]
        public Dictionary<int, int> Spells = new Dictionary<int, int>();
    }

    public class FishingInstanceData
    {
        [LuaField("locations")]
        public new Dictionary<string, Dictionary<string, FishingStoreData>> Locations = new Dictionary<string, Dictionary<string, FishingStoreData>>();
    }
}
