﻿using System;
using LuaSerialization;
using System.Collections.Generic;
using Curse.Azeroth.Models.Extensions;

namespace Curse.Azeroth.Models.WoW
{
    public class Item
    {
        public int Id { get; set; }
        public int Durability { get; set; }
        public int DisenchantCount { get; set; }
        public List<Disenchant> Disenchant { get; set; }
    }
    public class Disenchant
    {
        public int ItemId { get; set; }
        public int Quantity { get; set; }
        public Disenchant(string disenchantData)
        {
            var data = disenchantData.ColonDelimited();
            try
            {
                ItemId = Int32.Parse(data[0]);
                Quantity = Int32.Parse(data[1]);
            }
            catch (Exception exc)
            {
                throw new ArgumentException("Invalid disenchantment data", exc);
            }
        }
    }
    public class ItemData
    {
        [LuaField("durability")]
        public int Durability { get; set; }

        [LuaField("disenchant_count")]
        public int DisenchantCount { get; set; }

        [LuaField("disenchant")]
        public string[] Disecnchant { get; set; }
    }
}
