﻿using System;
using System.Collections.Generic;
using Curse.Azeroth.Models.Extensions;

namespace Curse.Azeroth.Models.WoW
{
    public class Coordinate
    {
        public int MapLevel { get; set; }
        public float X { get; set; }
        public float Y { get; set; }
        public int DropCount { get; set; }
        public List<Drop> Drops = new List<Drop>();


        public Coordinate(string coordString)
        {
            var coordData = coordString.ColonDelimited();
            this.MapLevel = int.Parse(coordData[0]);
            
            var X = float.Parse(coordData[1]);
            this.X = (int)(X * 10);

            var Y = float.Parse(coordData[2]);
            this.Y = (int)(Y * 10);
        }
    }
    public class Location
    {
        public int LocationID { get; set; }
        public string LocationName { get; set; }
        public List<Coordinate> Coordinates = new List<Coordinate>();

        public Location(string locationString)
        {
            var locationData = locationString.ColonDelimited();
            this.LocationName = locationData[0];
            this.LocationID = int.Parse(locationData[1]);
        }
    }
    public class LocationStore : Dictionary<string, bool>
    {
        List<Coordinate> _coordinates;
        public List<Coordinate> Coordinates
        {
            get
            {
                if (_coordinates == null || _coordinates.Count != this.Count)
                {
                    _coordinates = new List<Coordinate>();
                    foreach (string key in this.Keys)
                    {
                        var loc = new Coordinate(key);
                        _coordinates.Add(loc);
                    }
                }

                return _coordinates;
            }
        }
    }
}
