﻿using System;
using System.Linq;
using LuaSerialization;
using System.Collections.Generic;
using Curse.Azeroth.Models.Extensions;

namespace Curse.Azeroth.Models.WoW
{
    public class Quest
    {
        public int Id { get; set; }
        public QuestGiver BeginningQuestGiver { get; set; }
        public QuestGiver EndingQuestGiver { get; set; }
        public List<string> RaceNames { get; set; }
        public List<string> ClassNames { get; set; }
        public int Timer { get; set; }
        public bool CanShare { get; set; }
    }
    public enum QuestGiverType
    {
        UNKNOWN = 1,
        NPC,
        OBJECT
    }
    public class QuestGiver
    {
        public int QuestGiverId { get; set; }
        public QuestGiverType QuestGiverType { get; set; }
    }
    public class QuestData
    {
        [LuaField("begin")]
        public Dictionary<string, bool> Begin { get; set; }
        public QuestGiver BeginningQuestGiver
        {
            get
            {
                if (Begin != null)
                {
                    var data = Begin.Keys.First().ColonDelimited();

                    var questGiver = new QuestGiver
                    {
                        QuestGiverId = int.Parse(data[1])
                    };

                    switch (data[0].ToUpper())
                    {
                        case "NPC":
                            questGiver.QuestGiverType = QuestGiverType.NPC;
                            break;
                        case "OBJECT":
                            questGiver.QuestGiverType = QuestGiverType.OBJECT;
                            break;
                        default:
                            questGiver.QuestGiverType = QuestGiverType.UNKNOWN;
                            break;
                    }

                    return questGiver;
                }
                return null;
            }
        }

        [LuaField("end")]
        public Dictionary<string, bool> End { get; set; }
        public QuestGiver EndingQuestGiver
        {
            get
            {
                if (End != null)
                {
                    var data = End.Keys.First().ColonDelimited();

                    var questGiver = new QuestGiver
                    {
                        QuestGiverId = int.Parse(data[1])
                    };

                    switch (data[0].ToUpper())
                    {
                        case "NPC":
                            questGiver.QuestGiverType = QuestGiverType.NPC;
                            break;
                        case "OBJECT":
                            questGiver.QuestGiverType = QuestGiverType.OBJECT;
                            break;
                        default:
                            questGiver.QuestGiverType = QuestGiverType.UNKNOWN;
                            break;
                    }

                    return questGiver;
                }
                return null;
            }
        }

        [LuaField("classes")]
        public Dictionary<string, bool> Classes { get; set; }

        [LuaField("races")]
        public Dictionary<string, bool> Races { get; set; }

        [LuaField("timer")]
        public int Timer { get; set; }

        [LuaField("can_share")]
        public bool CanShare { get; set; }
    }
}
