﻿using System;
using LuaSerialization;
using Curse.Extensions;
using Curse.Azeroth.Models.WoW;
using Curse.Azeroth.Extensions;
using System.Collections.Generic;
using Curse.Azeroth.Models.Extensions;

namespace Curse.Azeroth.Models
{
    public class WowUpdate : Update
    {
        public int Build { get; set; }
        public List<Item> Items { get; set; }
        public List<GameObject> GameObjects { get; set; }
        public List<Quest> Quests { get; set; }
        public List<Npc> Npcs { get; set; }
        public List<GameObject> FishingNodes { get; set; }

        public WowUpdate(long minProfilerVersion, int[] supportedClientVersions, string[] supportedLocals, int userId, bool isTrustedUser)
            : base(minProfilerVersion, supportedClientVersions, supportedLocals, userId, isTrustedUser)
        {

        }

        #region IUpdate Members
        public override void Clear()
        {
            Items.Clear();
            GameObjects.Clear();
            Quests.Clear();
            Npcs.Clear();
        }
        #endregion

        #region IPackable Members
        public override bool Read(IReadable buffer)
        {
            try
            {
                //string data = ((Package)buffer).DumpToString();

                //var luaSerializer = new LuaSerializer();
                //WoWDBProfilerData profileData = luaSerializer.DeserializeGlobal<WoWDBProfilerData>(data, typeof(WoWDBProfilerData).Name);
                //if (profileData == null)
                //{
                //    UpdateStatus = StatusCode.InvalidStream;
                //    return false;
                //}

                //Build = profileData.Build;
                //#region Items
                //Items = new List<Item>();
                //if (profileData.Global.ItemData != null)
                //{
                //    foreach (int key in profileData.Global.ItemData.Keys)
                //    {
                //        // Durabilities
                //        var item = new Item
                //        {
                //            Id = key,
                //            Durability = profileData.Global.ItemData[key].Durability,
                //            DisenchantCount = profileData.Global.ItemData[key].DisenchantCount
                //        };

                //        // Disenchants
                //        item.Disenchant = new List<Disenchant>();
                //        if (profileData.Global.ItemData[key].Disecnchant != null)
                //        {
                //            foreach (var disenchantData in profileData.Global.ItemData[key].Disecnchant)
                //            {
                //                var disenchant = new Disenchant(disenchantData);
                //                item.Disenchant.Add(disenchant);
                //            }
                //        }

                //        Items.Add(item);
                //    }
                //}
                //#endregion

                //#region GameObjects
                //GameObjects = new List<GameObject>();
                //if (profileData.Global.GameObjectData != null)
                //{
                //    foreach (string key in profileData.Global.GameObjectData.Keys)
                //    {
                //        var gameObject = new GameObject();

                //        #region DropSourceType
                //        int objectId = 0;
                //        if (Int32.TryParse(key, out objectId))
                //        {
                //            gameObject.ID = objectId;
                //            gameObject.GameObjectSource = DropSourceType.UNKNOWN;
                //        }
                //        else
                //        {
                //            var keyData = key.ColonDelimited();
                //            gameObject.Name = keyData[1];

                //            switch (keyData[0].ToUpper())
                //            {
                //                case "HERB_GATHERING":
                //                    gameObject.GameObjectSource = DropSourceType.HERB_GATHERING;
                //                    break;
                //                case "MINING":
                //                    gameObject.GameObjectSource = DropSourceType.MINING;
                //                    break;
                //                case "OPENING":
                //                    gameObject.GameObjectSource = DropSourceType.OPENING;
                //                    break;
                //                case "SKINNING":
                //                    gameObject.GameObjectSource = DropSourceType.SKINNING;
                //                    break;
                //                case "PICK_POCKET":
                //                    gameObject.GameObjectSource = DropSourceType.PICK_POCKET;
                //                    break;
                //                case "SEARCHING_FOR_ARTIFACTS":
                //                    gameObject.GameObjectSource = DropSourceType.SEARCHING_FOR_ARTIFACTS;
                //                    break;
                //                default:
                //                    gameObject.GameObjectSource = DropSourceType.UNKNOWN;
                //                    break;
                //            }
                //        }
                //        #endregion

                //        gameObject.InstanceInfo = new List<InstanceInfo>();
                //        foreach (var instanceKey in profileData.Global.GameObjectData[key].Keys)
                //        {
                //            var instanceInfo = new InstanceInfo(instanceKey);

                //            #region Locations
                //            instanceInfo.Locations = new List<Location>();
                //            foreach (string locationKey in profileData.Global.GameObjectData[key][instanceKey].Locations.Keys)
                //            {
                //                var location = new Location(locationKey)
                //                {
                //                    Coordinates = profileData.Global.GameObjectData[key][instanceKey].Locations[locationKey].Coordinates
                //                };

                //                instanceInfo.Locations.Add(location);
                //            }
                //            #endregion
                //            #region Drops
                //            instanceInfo.Drops = new List<Drop>();
                //            if (profileData.Global.GameObjectData[key][instanceKey].Drops != null)
                //            {
                //                foreach (string dropKey in profileData.Global.GameObjectData[key][instanceKey].Drops)
                //                {
                //                    Drop drop = new Drop(dropKey);
                //                    if (drop != null)
                //                    {
                //                        instanceInfo.Drops.Add(drop);
                //                    }
                //                }
                //            }
                //            #endregion

                //            gameObject.InstanceInfo.Add(instanceInfo);
                //        }

                //        GameObjects.Add(gameObject);
                //    }
                //}
                //#endregion

                //#region Quests
                //Quests = new List<Quest>();
                //if (profileData.Global.QuestData != null)
                //{
                //    foreach (int key in profileData.Global.QuestData.Keys)
                //    {
                //        var quest = new Quest
                //        {
                //            Id = key,
                //            BeginningQuestGiver = profileData.Global.QuestData[key].BeginningQuestGiver,
                //            EndingQuestGiver = profileData.Global.QuestData[key].EndingQuestGiver,
                //            Timer = profileData.Global.QuestData[key].Timer,
                //            CanShare = profileData.Global.QuestData[key].CanShare
                //        };

                //        //Classes
                //        quest.ClassNames = new List<string>();
                //        if (profileData.Global.QuestData[key].Classes != null)
                //        {
                //            foreach (var classData in profileData.Global.QuestData[key].Classes)
                //            {
                //                quest.ClassNames.Add(classData.Key);
                //            }
                //        }

                //        //Races
                //        quest.RaceNames = new List<string>();
                //        if (profileData.Global.QuestData[key].Races != null)
                //        {
                //            foreach (var raceData in profileData.Global.QuestData[key].Races)
                //            {
                //                quest.RaceNames.Add(raceData.Key);
                //            }
                //        }

                //        Quests.Add(quest);
                //    }
                //}
                //#endregion

                //#region Npc
                //Npcs = new List<Npc>();
                //if (profileData.Global.NpcData != null)
                //{
                //    foreach (int key in profileData.Global.NpcData.Keys)
                //    {
                //        var npc = new Npc
                //        {
                //            Id = key,
                //            IsPvP = profileData.Global.NpcData[key].IsPvP,
                //            Faction = profileData.Global.NpcData[key].Faction ?? string.Empty,
                //            Repairs = profileData.Global.NpcData[key].Repairs
                //        };

                //        #region Sells
                //        npc.VendorItems = new List<NpcItem>();
                //        foreach (string itemKey in profileData.Global.NpcData[key].Sells.Keys)
                //        {
                //            var itemData = itemKey.ColonDelimited();
                //            var item = new NpcItem
                //            {
                //                Id = int.Parse(itemData[0]),
                //                StackSize = int.Parse(itemData[1]),
                //                NumAvailable = profileData.Global.NpcData[key].Sells[itemKey]
                //            };

                //            // Limited Availability
                //            item.LimitedAvailability = (item.NumAvailable == -1) ? 0 : item.NumAvailable;

                //            // Cost
                //            int cost = 0;
                //            if (int.TryParse(itemData[2], out cost))
                //            {
                //                item.CurrencyType = CurrencyType.COPPER;
                //                item.Price = cost;
                //            }
                //            else // if we have extended costs
                //            {
                //                var extendedData = itemData[2].ColonDelimited();
                //                item.CurrencyType = CurrencyType.EXTENDED;

                //                item.ExtendedCost = new NpcItemExtendedCost
                //                {
                //                    CopperCost = int.Parse(extendedData[0]),
                //                    BattleGroundRating = int.Parse(extendedData[1]),
                //                    PersonalRating = int.Parse(extendedData[2])
                //                };

                //                // Items and Currencys
                //                for (int i = 3; i < extendedData.Length; i++)
                //                {
                //                    var extendedItemData = extendedData[i].ColonDelimited();

                //                    int itemId = 0;
                //                    if (int.TryParse(extendedItemData[1], out itemId))
                //                    {
                //                        var extendedItem = new ExtendedCostItem
                //                        {
                //                            ItemID = itemId,
                //                            Quantity = int.Parse(extendedItemData[0])
                //                        };
                //                        item.ExtendedCost.Items.Add(extendedItem);
                //                    }
                //                    else
                //                    {
                //                        var extendedCurrency = new ExtendedCostCurrency
                //                        {
                //                            Quantity = int.Parse(extendedItemData[0]),
                //                            CurrenctName = extendedItemData[1]
                //                        };
                //                        item.ExtendedCost.Currencys.Add(extendedCurrency);
                //                    }
                //                }
                //            }

                //            npc.VendorItems.Add(item);
                //        }
                //        #endregion

                //        #region Gender
                //        // TODO: This is removed as none of the current views require it and it has been changed
                //        //switch (profileData.Global.NpcData[key].Gender)
                //        //{
                //        //    case "MALE":
                //        //        npc.Gender = NpcGender.MALE;
                //        //        break;
                //        //    case "FEMALE":
                //        //        npc.Gender = NpcGender.FEMALE;
                //        //        break;
                //        //    default:
                //        //        npc.Gender = NpcGender.UNKNOWN;
                //        //        break;
                //        //}
                //        #endregion

                //        #region Class
                //        switch (profileData.Global.NpcData[key].Class)
                //        {
                //            case "WARRIOR":
                //                npc.Class = NpcClass.Warrior;
                //                break;
                //            case "PALADIN":
                //                npc.Class = NpcClass.Paladin;
                //                break;
                //            case "MAGE":
                //                npc.Class = NpcClass.Mage;
                //                break;
                //            case "DEATHKNIGHT":
                //                npc.Class = NpcClass.DeathKnight;
                //                break;
                //            case "DRUID":
                //                npc.Class = NpcClass.Druid;
                //                break;
                //            case "HUNTER":
                //                npc.Class = NpcClass.Hunter;
                //                break;
                //            case "PRIEST":
                //                npc.Class = NpcClass.Priest;
                //                break;
                //            case "ROGUE":
                //                npc.Class = NpcClass.Rogue;
                //                break;
                //            case "SHAMAN":
                //                npc.Class = NpcClass.Shaman;
                //                break;
                //            case "WARLOCK":
                //                npc.Class = NpcClass.Warlock;
                //                break;
                //            case "MONK":
                //                npc.Class = NpcClass.Monk;
                //                break;
                //            default:
                //                npc.Class = NpcClass.None;
                //                break;
                //        }
                //        #endregion

                //        #region Reaction
                //        if (profileData.Global.NpcData[key].Reaction != null)
                //        {
                //            var reactionData = profileData.Global.NpcData[key].Reaction.ColonDelimited();
                //            npc.Reaction = new NpcReaction { Level = int.Parse(reactionData[0]) };
                //            switch (reactionData[1].ToUpper())
                //            {
                //                case "HORDE":
                //                    npc.Reaction.Faction = NpcReactionFaction.HORDE;
                //                    break;
                //                case "ALLIANCE":
                //                    npc.Reaction.Faction = NpcReactionFaction.ALLIANCE;
                //                    break;
                //                default:
                //                    npc.Reaction.Faction = NpcReactionFaction.UNKNOWN;
                //                    break;
                //            }
                //            switch (reactionData[2])
                //            {
                //                case "HOSTILE":
                //                    npc.Reaction.ReactionType = NpcReactionType.HOSTILE;
                //                    break;
                //                case "FRIENDLY":
                //                    npc.Reaction.ReactionType = NpcReactionType.FRIENDLY;
                //                    break;
                //                case "NEUTRAL":
                //                    npc.Reaction.ReactionType = NpcReactionType.NEUTRAL;
                //                    break;
                //                default:
                //                    npc.Reaction.ReactionType = NpcReactionType.UNKNOWN;
                //                    break;
                //            }
                //        }
                //        #endregion

                //        #region EncounterData
                //        npc.Encounters = new List<InstanceInfo>();
                //        foreach (string encounterKey in profileData.Global.NpcData[key].EncounterData.Keys)
                //        {
                //            // Top level encounter data
                //            var encounter = new InstanceInfo(encounterKey);

                //            #region Stat Information
                //            foreach (var statKey in profileData.Global.NpcData[key].EncounterData[encounterKey].Stats.Keys)
                //            {
                //                var npcStat = new NpcStats { MaxHealth = profileData.Global.NpcData[key].EncounterData[encounterKey].Stats[statKey].MaxHealth };

                //                // Level
                //                int npcLevel = 0;
                //                Int32.TryParse(statKey.Substring(statKey.IndexOf("_") + 1), out npcLevel);
                //                npcStat.Level = npcLevel;

                //                //Locations
                //                npcStat.Locations = new List<Location>();
                //                foreach (string locationKey in profileData.Global.NpcData[key].EncounterData[encounterKey].Stats[statKey].Locations.Keys)
                //                {
                //                    var location = new Location(locationKey)
                //                    {
                //                        Coordinates = profileData.Global.NpcData[key].EncounterData[encounterKey].Stats[statKey].Locations[locationKey].Coordinates
                //                    };

                //                    npcStat.Locations.Add(location);
                //                }

                //                // Powers
                //                if (!string.IsNullOrEmpty(profileData.Global.NpcData[key].EncounterData[encounterKey].Stats[statKey].Power))
                //                {
                //                    var powerData = profileData.Global.NpcData[key].EncounterData[encounterKey].Stats[statKey].Power.ColonDelimited();
                //                    switch (powerData[0].ToUpper())
                //                    {
                //                        case "MANA":
                //                            npcStat.PowerType = PowerType.Mana;
                //                            break;
                //                        case "ENERGY":
                //                            npcStat.PowerType = PowerType.Energy;
                //                            break;
                //                        case "RAGE":
                //                            npcStat.PowerType = PowerType.Rage;
                //                            break;
                //                        default:
                //                            npcStat.PowerType = (PowerType)(-1);
                //                            break;
                //                    }
                //                    npcStat.PowerValue = int.Parse(powerData[1]);
                //                }

                //                // Reputations
                //                npcStat.Reputations = new List<NpcReputation>();
                //                foreach (var reputationKey in profileData.Global.NpcData[key].EncounterData[encounterKey].Stats[statKey].Reputations.Keys)
                //                {
                //                    var reputationData = reputationKey.ColonDelimited();
                //                    var reputation = new NpcReputation
                //                    {
                //                        FactionName = reputationData[0],
                //                        Amount = profileData.Global.NpcData[key].EncounterData[encounterKey].Stats[statKey].Reputations[reputationKey]
                //                    };

                //                    // Standing
                //                    switch (reputationData[1].ToUpper())
                //                    {
                //                        case "HATED":
                //                            reputation.PlayerStanding = FactionStandingReputation.Hated;
                //                            break;
                //                        case "HOSTILE":
                //                            reputation.PlayerStanding = FactionStandingReputation.Hostile;
                //                            break;
                //                        case "UNFRIENDLY":
                //                            reputation.PlayerStanding = FactionStandingReputation.Unfriendly;
                //                            break;
                //                        case "NEUTRAL":
                //                            reputation.PlayerStanding = FactionStandingReputation.Neutral;
                //                            break;
                //                        case "FRIENDLY":
                //                            reputation.PlayerStanding = FactionStandingReputation.Friendly;
                //                            break;
                //                        case "HONORED":
                //                            reputation.PlayerStanding = FactionStandingReputation.Honored;
                //                            break;
                //                        case "REVERED":
                //                            reputation.PlayerStanding = FactionStandingReputation.Revered;
                //                            break;
                //                        case "EXAULTED":
                //                            reputation.PlayerStanding = FactionStandingReputation.Exalted;
                //                            break;
                //                    }

                //                    npcStat.Reputations.Add(reputation);
                //                }

                //                encounter.Stats.Add(npcStat);
                //            }
                //            #endregion

                //            #region Spell Information
                //            encounter.SpellIds = new List<int>();
                //            if (profileData.Global.NpcData[key].EncounterData[encounterKey].Spells != null)
                //            {
                //                foreach (var spellKey in profileData.Global.NpcData[key].EncounterData[encounterKey].Spells.Keys)
                //                {
                //                    encounter.SpellIds.Add(spellKey);
                //                }
                //            }
                //            #endregion

                //            #region Drop Information
                //            encounter.Drops = new List<Drop>();
                //            if (profileData.Global.NpcData[key].EncounterData[encounterKey].Drops != null)
                //            {
                //                foreach (var dropKey in profileData.Global.NpcData[key].EncounterData[encounterKey].Drops)
                //                {
                //                    var drop = new Drop(dropKey);
                //                    if (drop != null)
                //                    {
                //                        encounter.Drops.Add(drop);
                //                    }
                //                }
                //            }
                //            #endregion

                //            npc.Encounters.Add(encounter);
                //        }
                //        #endregion

                //        #region Teaches
                //        if (profileData.Global.NpcData[key].Teaches != null)
                //        {
                //            foreach (var classKey in profileData.Global.NpcData[key].Teaches.Keys)
                //            {
                //                foreach (var professionKey in profileData.Global.NpcData[key].Teaches[classKey].Keys)
                //                {
                //                    foreach (var skillKey in profileData.Global.NpcData[key].Teaches[classKey][professionKey].Keys)
                //                    {
                //                        var skillData = profileData.Global.NpcData[key].Teaches[classKey][professionKey][skillKey].ColonDelimited();
                //                        var skillRequirement = new TradeSkillRequirement
                //                        {
                //                            ClassName = classKey,
                //                            ProfessionName = professionKey,
                //                            SkillID = skillKey,
                //                            RequiredLevel = Int32.Parse(skillData[0]),
                //                            RequiredSkill = Int32.Parse(skillData[1])
                //                        };

                //                        npc.TradeSkillRequirements.Add(skillRequirement);
                //                    }
                //                }
                //            }
                //        }
                //        #endregion

                //        #region LootCount
                //        if (profileData.Global.NpcData[key].LootCountData != null)
                //        {
                //            npc.LootCount = profileData.Global.NpcData[key].LootCountData.DropLootCount;
                //        }
                //        #endregion

                //        Npcs.Add(npc);
                //    }
                //}
                //#endregion

                //#region Zones
                //FishingNodes = new List<GameObject>();
                //if (profileData.Global.ZoneData != null)
                //{
                //    foreach (var zoneKey in profileData.Global.ZoneData.Keys)
                //    {
                //        var zoneData = zoneKey.ColonDelimited();
                //        var fishingNode = new GameObject
                //        {
                //            Name = zoneData[1],
                //            GameObjectSource = DropSourceType.FISHING,
                //            InstanceInfo = new List<InstanceInfo>()
                //        };

                //        foreach (var instanceKey in profileData.Global.ZoneData[zoneKey].Keys)
                //        {
                //            var instanceInfo = new InstanceInfo(instanceKey)
                //            {
                //                Locations = new List<Location>()
                //            };

                //            foreach (var locationKey in profileData.Global.ZoneData[zoneKey][instanceKey].Locations.Keys)
                //            {
                //                var location = new Location(locationKey);

                //                foreach (var coordKey in profileData.Global.ZoneData[zoneKey][instanceKey].Locations[locationKey].Keys)
                //                {
                //                    var coord = new Coordinate(coordKey)
                //                    {
                //                        DropCount = profileData.Global.ZoneData[zoneKey][instanceKey].Locations[locationKey][coordKey].DropCount,
                //                        Drops = new List<Drop>()
                //                    };

                //                    foreach (var dropKey in profileData.Global.ZoneData[zoneKey][instanceKey].Locations[locationKey][coordKey].Drops)
                //                    {
                //                        var drop = new Drop(dropKey);
                //                        if (drop.Valid)
                //                        {
                //                            coord.Drops.Add(drop);
                //                        }
                //                    }

                //                    location.Coordinates.Add(coord);
                //                }

                //                instanceInfo.Locations.Add(location);
                //            }

                //            fishingNode.InstanceInfo.Add(instanceInfo);
                //        }

                //        FishingNodes.Add(fishingNode);
                //    }
                //}
                //#endregion

                return true;
            }
            catch (Exception exc)
            {
                Logger.Log("Failed to read WowUpdate. Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                UpdateStatus = StatusCode.InvalidStream;
                return false;
            }
        }
        public override bool Write(IWriteable buffer)
        {
            return true;
        }
        #endregion
    }
}