﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.ClientService.Models
{
    [DataContract]
    public class CCampaign : INotifyPropertyChanged
    {
        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        [DataMember]
        public int ID
        {
            get;
            set;
        }

        [DataMember]
        public string Name
        {
            get;
            set;
        }


        [DataMember]
        public DateTime DateCreated
        {
            get;
            set;
        }

        [DataMember]
        public DateTime DateModified
        {
            get;
            set;
        }

        [DataMember]
        public DateTime StartDate
        {
            get;
            set;
        }

        [DataMember]
        public DateTime EndDate
        {
            get;
            set;
        }

        [DataMember]
        public string ThemeToken
        {
            get;
            set;
        }

        [DataMember]
        public string LinkUrl
        {
            get;
            set;
        }

        public IEnumerable<int> Regions
        {
            get;
            set;
        }


       
    }
}
