﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace Curse.ClientService.Models
{
    [DataContract]
    public class CHardwareProfile
    {
        #region Miscellaneous

        public int UserID
        {
            get;
            set;
        }

        [DataMember]
        public string ComputerName
        {
            get;
            set;
        }

        [DataMember]
        public string LanguageName
        {
            get;
            set;
        }

        [DataMember]
        public bool IsLaptop
        {
            get;
            set;
        }

        [DataMember]
        public string DirectXVersionName
        {
            get;
            set;
        }

        [DataMember]
        public string OSVersionName
        {
            get;
            set;
        }

        [DataMember]
        public bool OSIs64Bit
        {
            get;
            set;
        }

        [DataMember]
        public string OSServicePackName
        {
            get;
            set;
        }
        [DataMember]
        public int OSVersionMajor
        {
            get;
            set;
        }
        
        [DataMember]
        public int OSVersionMajorRevision
        {
            get;
            set;
        }

        [DataMember]
        public int OSVersionMinor
        {
            get;
            set;
        }

        [DataMember]
        public int OSVersionMinorRevision
        {
            get;
            set;
        }
        #endregion

        #region RAM

        [DataMember]
        public string RamManufacturerName
        {
            get;
            set;
        }

        [DataMember]
        public string RamTypeName
        {
            get;
            set;
        }


        [DataMember]
        public int RamSize
        {
            get;
            set;
        }

        [DataMember]
        public int RamFrequency
        {
            get;
            set;
        }

        #endregion

        #region CPU

        [DataMember]
        public string CpuManufacturerName
        {
            get;
            set;
        }        

        [DataMember]
        public string CpuDescription
        {
            get;
            set;
        }

        [DataMember]
        public int CpuFrequency
        {
            get;
            set;
        }

        [DataMember]
        public byte CpuCount
        {
            get;
            set;
        }

        #endregion

        #region GPU

        [DataMember]
        public string GpuManufacturerName
        {
            get;
            set;
        }

        [DataMember]
        public string GpuDescription
        {
            get;
            set;
        }

        [DataMember]
        public string GpuDriverName
        {
            get;
            set;
        }

        [DataMember]
        public string GpuDriverVersionName
        {
            get;
            set;
        }

        [DataMember]
        public DateTime GpuDriverDate
        {
            get;
            set;
        }

        [DataMember]
        public int GpuMemorySize
        {
            get;
            set;
        }

        [DataMember]
        public byte GpuCount
        {
            get;
            set;
        }

        #endregion

        #region Display

        [DataMember]
        public string MonitorDescription
        {
            get;
            set;
        }

        [DataMember]
        public int MonitorResolutionWidth
        {
            get;
            set;
        }

        [DataMember]
        public int MonitorResolutionHeight
        {
            get;
            set;
        }

        [DataMember]
        public byte MonitorCount
        {
            get;
            set;
        }

        #endregion

        #region Sound

        [DataMember]
        public bool SoundIsPresent
        {
            get;
            set;
        }

        [DataMember]
        public string SoundDescription
        {
            get;
            set;
        }

        [DataMember]
        public bool SoundIsPci
        {
            get;
            set;
        }

        [DataMember]
        public bool SoundIsHwAccel
        {
            get;
            set;
        }

        #endregion

        #region HDD

        [DataMember]
        public byte HDDCount
        {
            get;
            set;
        }        

        [DataMember]
        public int HDDTotalSpace
        {
            get;
            set;
        }

        [DataMember]
        public int HDDFreeSpace
        {
            get;
            set;
        }


        #endregion

    }
}
