﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.ClientService.Models
{    

    [Serializable]
    [DataContract]
    public class CNotification : INotifyPropertyChanged
    {

        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;        

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }
        #endregion

        
        [DataMember]
        public int ID
        {
            get;
            set;
        }

        [DataMember]
        public string Subject
        {
            get;
            set;
        }

        [DataMember]
        public string Body
        {
            get;
            set;
        }

        [DataMember]
        public DateTime DateCreated
        {
            get;
            set;
        }

        [DataMember]
        public int Recipients
        {
            get;
            set;
        }

        [DataMember]
        public ENotificationType Type
        {
            get;
            set;
        }

        private DateTime _dateExpires;

        public DateTime DateExpires
        {
            get
            {
                return _dateExpires;
            }
            set
            {
                _dateExpires = value;
            }

        }
        private DateTime _dateRead;

        public DateTime DateRead
        {
            get
            {
                return _dateRead;
            }
            set
            {
                if (_dateRead != value)
                {
                    _dateRead = value;
                    OnPropertyChanged("DateRead");
                }
            }
        }

        private bool _isRead;
        public bool IsRead
        {
            get
            {
                return _isRead;
            }
            set
            {
                if (_isRead != value)
                {
                    _isRead = value;
                    OnPropertyChanged("IsRead");
                }
            }
        }
        
    }
}
