﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.ClientService.Models {
    public enum ESavedGameStatus {
        Private = 1,
        Public
    }

    public enum ESavedGameRestrictionLevel {
        Disabled = 1,
        PremiumOnly,
        AllUsers
    }

    public class CSavedGame {
        #region Properties
        public int ID { get; set; }
        public int UserID { get; set; }
        public int GameID { get; set; }
        public string Name { get; set; }
        public string Description { get; set; }
        public string FileName { get; set; }
        public DateTime DateCreated { get; set; }
        public DateTime DateModified { get; set; }
        public ESavedGameStatus Status { get; set; }

        public int DefaultRevisionID { get; set; }
        public List<CSavedGameRevision> SavedGameRevisions { get; set; }

        public long TotalSize
        {
            get
            {
                if (SavedGameRevisions != null)
                {
                    return SavedGameRevisions.Sum( p=> p.FileSize);
                }

                return 0;
            }
        }
        #endregion

        public CSavedGame() { }
    }
}
